% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{beta2norm}
\alias{beta2norm}
\title{Convert beta to normal}
\usage{
beta2norm(x, mu = 0, sd = 1, shape1 = NULL, shape2 = NULL, ...)
}
\arguments{
\item{x}{the gamma distributed vector}

\item{mu}{the mean of the normal distribution to convert to}

\item{sd}{the SD of the normal distribution to convert to}

\item{shape1, shape2}{non-negative parameters of the beta distribution}

\item{...}{further arguments to pass to pbeta (e.g., ncp)}
}
\value{
a vector with a normal distribution
}
\description{
Convert beta to normal
}
\examples{

x <- rbeta(10000, 2, 3)
y <- beta2norm(x)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
