% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_trace.R
\name{explore_trace_search}
\alias{explore_trace_search}
\title{Plot the count in each iteration}
\usage{
explore_trace_search(
  dt,
  iter = NULL,
  color = NULL,
  cutoff = 15,
  extend_lower = 0.95,
  ...
)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in \code{tourr}}

\item{iter}{the variable to be plotted on the x-axis}

\item{color}{the variable to be coloured by}

\item{cutoff}{numeric; if the number of searches in one iteration is smaller than \code{cutoff}, a point geom, rather than boxplot geom, will be used.}

\item{extend_lower}{a numeric for extending the y-axis to display text labels}

\item{...}{arguments passed into geom_label_repel() for displaying text labels}
}
\value{
a ggplot object for diagnosing how many points the optimiser(s) have searched
}
\description{
Plot the count in each iteration
}
\examples{
# Summary plots for search points in two algorithms
library(patchwork)
library(dplyr)
library(ggplot2)
p1 <- holes_1d_better \%>\% explore_trace_search() +
  scale_color_continuous_botanical(palette = "fern")
p2 <- holes_2d_better_max_tries \%>\% explore_trace_search() +
  scale_color_continuous_botanical(palette = "daisy")
p1 / p2
}
\seealso{
Other main plot functions: 
\code{\link{explore_space_start}()},
\code{\link{explore_space_tour}()},
\code{\link{explore_trace_interp}()}
}
\concept{main plot functions}
