% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-pettitt-test.R
\name{plot_pettitt_test}
\alias{plot_pettitt_test}
\title{Plot Results from the Pettitt Change‐Point Test}
\usage{
plot_pettitt_test(results, show_line = TRUE, ...)
}
\arguments{
\item{results}{A list generated by \code{\link[=eda_pettitt_test]{eda_pettitt_test()}}.}

\item{show_line}{If \code{TRUE} (default), draw a fitted line through the data.}

\item{...}{Optional named arguments: 'title', 'top_xlabel', 'top_ylabel',
'bottom_xlabel' and 'bottom_ylabel'.}
}
\value{
A \code{patchwork} object with two \code{ggplot2} panels stacked vertically.
}
\description{
Creates a two‐panel visualization of the Mann–Whitney–Pettitt test. The
upper panel plots the Pettitt \eqn{U_t} statistic over time along with the
significance threshold and potential change point. The lower panel displays
the annual maximum series data with an optional trend line, the period
mean(s), and potential change point(s).
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
years <- seq(from = 1901, to = 2000)
results <- eda_pettitt_test(data, years)
plot_pettitt_test(results)

}
\seealso{
\code{\link[=eda_pettitt_test]{eda_pettitt_test()}}
}
