% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_linear_sat}
\alias{fn_linear_sat}
\title{Linear plateau function}
\usage{
fn_linear_sat(t, t1 = 45, t2 = 80, k = 0.9)
}
\arguments{
\item{t}{Numeric. The time value.}

\item{t1}{Numeric. The lower threshold time. Default is 45.}

\item{t2}{Numeric. The upper threshold time. Default is 80.}

\item{k}{Numeric. The maximum value of the function. Default is 0.9. Assumed to be known.}
}
\value{
A numeric value based on the threshold model.
If \code{t} is less than \code{t1}, the function returns 0.
If \code{t} is between \code{t1} and \code{t2} (inclusive),
the function returns a value between 0 and \code{k} in a linear trend.
If \code{t} is greater than \code{t2}, the function returns \code{k}.
}
\description{
Computes a value based on a linear growth curve reaching a plateau for time.
}
\details{
\if{html}{
\deqn{
f(t; t_1, t_2, k) =
\begin{cases}
0 & \text{if } t < t_1 \\
\dfrac{k}{t_2 - t_1} \cdot (t - t_1) & \text{if } t_1 \leq t \leq t_2 \\
k & \text{if } t > t_2
\end{cases}
}
}
}
\examples{
library(flexFitR)
plot_fn(
  fn = "fn_linear_sat",
  params = c(t1 = 34.9, t2 = 61.8, k = 100),
  interval = c(0, 108),
  n_points = 2000,
  auc_label_size = 3
)
}
