% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtable_to_flextable.R
\name{as_flextable.xtable}
\alias{as_flextable.xtable}
\title{Transform a 'xtable' object into a flextable}
\usage{
\method{as_flextable}{xtable}(
  x,
  text.properties = fp_text_default(),
  format.args = getOption("xtable.format.args", NULL),
  rowname_col = "rowname",
  hline.after = getOption("xtable.hline.after", c(-1, 0, nrow(x))),
  NA.string = getOption("xtable.NA.string", ""),
  include.rownames = TRUE,
  rotate.colnames = getOption("xtable.rotate.colnames", FALSE),
  ...
)
}
\arguments{
\item{x}{\code{xtable} object}

\item{text.properties}{default text formatting properties}

\item{format.args}{List of arguments for the formatC function.
See argument \code{format.args} of \code{print.xtable}. Not yet
implemented.}

\item{rowname_col}{colname used for row names column}

\item{hline.after}{see \code{?print.xtable}.}

\item{NA.string}{see \code{?print.xtable}.}

\item{include.rownames}{see \code{?print.xtable}.}

\item{rotate.colnames}{see \code{?print.xtable}.}

\item{...}{unused arguments}
}
\description{
Get a \code{flextable} object from
a \code{xtable} object.
}
\examples{
library(officer)
if( require("xtable") ){

  data(tli)
  tli.table <- xtable(tli[1:10, ])
  align(tli.table) <- rep("r", 6)
  align(tli.table) <- "|r|r|clr|r|"
  ft_1 <- as_flextable(
    tli.table,
    rotate.colnames = TRUE,
    include.rownames = FALSE)
  ft_1 <- height(ft_1, i = 1, part = "header", height = 1)
  ft_1

  \donttest{
  Grade3 <- c("A","B","B","A","B","C","C","D","A","B",
    "C","C","C","D","B","B","D","C","C","D")
  Grade6 <- c("A","A","A","B","B","B","B","B","C","C",
    "A","C","C","C","D","D","D","D","D","D")
  Cohort <- table(Grade3, Grade6)
  ft_2 <- as_flextable(xtable(Cohort))
  ft_2 <- set_header_labels(ft_2, rowname = "Grade 3")
  ft_2 <- autofit(ft_2)
  ft_2 <- add_header(ft_2, A = "Grade 6")
  ft_2 <- merge_at(ft_2, i = 1, j = seq_len( ncol(Cohort) ) + 1,
    part = "header" )
  ft_2 <- bold(ft_2, j = 1, bold = TRUE, part = "body")
  ft_2 <- height_all(ft_2, part = "header", height = .4)
  ft_2

  temp.ts <- ts(cumsum(1 + round(rnorm(100), 0)),
    start = c(1954, 7), frequency = 12)
  ft_3 <- as_flextable(x = xtable(temp.ts, digits = 0),
    NA.string = "-")
  ft_3
  }
  detach("package:xtable", unload = TRUE)
}
}
\seealso{
Other as_flextable methods: 
\code{\link{as_flextable}()},
\code{\link{as_flextable.data.frame}()},
\code{\link{as_flextable.gam}()},
\code{\link{as_flextable.glm}()},
\code{\link{as_flextable.grouped_data}()},
\code{\link{as_flextable.htest}()},
\code{\link{as_flextable.kmeans}()},
\code{\link{as_flextable.lm}()},
\code{\link{as_flextable.merMod}()},
\code{\link{as_flextable.pam}()},
\code{\link{as_flextable.summarizor}()},
\code{\link{as_flextable.table}()},
\code{\link{as_flextable.tabular}()},
\code{\link{as_flextable.tabulator}()}
}
\concept{as_flextable methods}
