% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_florabr.R
\name{filter_florabr}
\alias{filter_florabr}
\title{Identify records outside natural ranges according to Flora e Funga do Brasil}
\usage{
filter_florabr(data, occ, species = "species", long = "x", lat = "y",
                      by_state = TRUE, buffer_state = 20, by_biome = TRUE,
                      buffer_biome = 20, by_endemism = TRUE,
                      buffer_brazil = 20, state_vect = NULL,
                      state_column = NULL, biome_vect = NULL,
                      biome_column = NULL, br_vect = NULL,
                      value = "flag&clean", keep_columns = TRUE,
                      verbose = TRUE)
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_florabr}} function.}

\item{occ}{(data.frame) a data.frame with the records of the species.}

\item{species}{(character) column name in occ with species names.
Default = "species"}

\item{long}{(character) column name in occ with longitude data. Default = "x"}

\item{lat}{(character) column name in occ with latitude data. Default = "y"}

\item{by_state}{(logical) filter records by state? Default = TRUE}

\item{buffer_state}{(numeric) buffer (in km) around the polygons of the
states of occurrence of the specie. Default = 20.}

\item{by_biome}{(logical) filter records by biome? Default = TRUE}

\item{buffer_biome}{(numeric) buffer (in km) around the polygons of the
biomes of occurrence of the specie. Default = 20.}

\item{by_endemism}{(logical) filter records by endemism? Default = TRUE}

\item{buffer_brazil}{(numeric) buffer (in km) around the polygons of the
brazil. Default = 20.}

\item{state_vect}{(SpatVector) a SpatVector of the Brazilian states. By
default, it uses the SpatVector provided by geobr::read_state(). It can be
another Spatvector, but the structure must be identical to
geobr::read_state().}

\item{state_column}{(character) name of the column in state_vect containing
state abbreviations. Only use if biome_vect is not null.}

\item{biome_vect}{(SpatVector) a SpatVector of the Brazilian biomes. By
default, it uses the SpatVector provided by geobr::read_biomes(). It can be
another SpatVector, but the structure must be identical to
geobr::read_biomes() with biome names in English.}

\item{biome_column}{(character) name of the column in biome_vect containing
names of brazilian biomes (in English: "Amazon", "Atlantic_Forest",
"Caatinga", "Cerrado", "Pampa" and "Pantanal". Only use if biome_vect is not
null.}

\item{br_vect}{(SpatVector) a SpatVector of brazil. By default, it uses the
SpatVector provided by geobr::read_state() after being aggregated/dissolved,}

\item{value}{(character) Defines output values. See Value section.
Default = "flag&clean".}

\item{keep_columns}{(logical) if TRUE, keep all the original columns of the
input occ. If False, keep only the columns species, long and lat.
Default = TRUE}

\item{verbose}{(logical) Whether to display species being filtered during
function execution. Set to TRUE to enable display, or FALSE to run silently.
Default = TRUE.}
}
\value{
Depending on the 'value' argument. If value = "flag", it returns the
same data.frame provided in data with additional columns indicating if the
record falls inside the natural range of the specie (TRUE) or outside
(FALSE).
If value = "clean", it returns a data.frame with only the records that passes
all the tests (TRUE for all the filters). If value = "flag&clean" (Default),
it returns a list with two data.frames: one with the flagged records and one
with the cleaned records.
}
\description{
This function removes or flags records outside of the species'
natural ranges according to information provided by the Flora e Funga do
Brasil database.
}
\details{
If by_state = TRUE and/or by_biome = TRUE, the function takes polygons
representing the states and/or biomes with confirmed occurrences of the
specie, draws a buffer around the polygons, and tests if the records of the
species fall inside it.
If by_endemism = TRUE, the function checks if the species is endemic to
brazil. If it is endemic, the function tests if the records of the specie
fall inside a polygon representing the boundaries of brazil (with a buffer).
}
\examples{
data("bf_data") #Load Flora e Funga do Brasil data
data("occurrences") #Load occurrences
pts <- subset(occurrences, species == "Myrcia hatschbachii")
fd <- filter_florabr(data = bf_data, occ = pts,
                    by_state = TRUE, buffer_state = 20,
                    by_biome = TRUE, buffer_biome = 20,
                    by_endemism = TRUE, buffer_brazil = 20,
                    state_vect = NULL,
                    biome_vect = NULL, br_vect = NULL,
                    value = "flag&clean", keep_columns = TRUE,
                    verbose = FALSE)
}
\references{
Flora e Funga do Brasil. Jardim Botânico do Rio de Janeiro. Available at:
http://floradobrasil.jbrj.gov.br/
}
