% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_gep.R
\name{flux_gep}
\alias{flux_gep}
\title{Calculates GEP}
\usage{
flux_gep(
  fluxes_df,
  type_col,
  f_datetime,
  f_flux = f_flux,
  id_cols,
  nee_arg = "NEE",
  er_arg = "ER",
  cols_keep = "none"
)
}
\arguments{
\item{fluxes_df}{a dataframe containing NEE and ER}

\item{type_col}{column containing type of flux (NEE or ER)}

\item{f_datetime}{column containing start of measurement as datetime}

\item{f_flux}{column containing flux values}

\item{id_cols}{columns used to identify each pair of ER and NEE}

\item{nee_arg}{argument designating NEE fluxes in type column}

\item{er_arg}{argument designating ER fluxes in type column}

\item{cols_keep}{columns to keep from \code{fluxes_df}. Values from NEE row will
be filled in GEP row. \code{none} (default) keeps only the columns in \code{id_cols},
flux, type and datetime columns; \code{all} keeps all the columns;
can also be a vector of column names.}
}
\value{
a dataframe with $GEP = NEE - ER$ in long format with GEP, NEE, and
ER as flux type, datetime, and any column specified in \code{cols_keep}.
Values of datetime and columns in \code{cols_keep} for GEP row are taken from
NEE measurements.
}
\description{
to calculate gross ecosystem production (GEP) from net ecosystem
(NEE) exchange and ecosystem respiration (ER) as GEP = NEE - ER.
Datetime and other variables to keep will be taken from the NEE measurement.
Fluxes presents in the dataset that are neither NEE nor ER
(soilR, LRC or other) are not lost.
}
\examples{
data(co2_fluxes)
flux_gep(co2_fluxes, type, f_start, id_cols = "turfID",
cols_keep = c("temp_soil"))
}
