% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_diff.R
\name{flux_diff}
\alias{flux_diff}
\title{Calculates difference between fluxes}
\usage{
flux_diff(
  fluxes_df,
  type_col,
  f_flux = f_flux,
  id_cols,
  type_a,
  type_b,
  diff_name,
  cols_keep = "none"
)
}
\arguments{
\item{fluxes_df}{a dataframe containing fluxes}

\item{type_col}{column containing type of flux}

\item{f_flux}{column containing flux values}

\item{id_cols}{columns used to identify each pair of fluxes}

\item{type_a}{argument designating type_a fluxes in type column}

\item{type_b}{argument designating type_b fluxes in type column}

\item{diff_name}{name to give to the new calculated flux}

\item{cols_keep}{columns to keep from \code{fluxes_df}. Values from type_a row
will be filled in diff row. \code{none} (default) keeps only the columns in
\code{id_cols}, flux, type and datetime columns; \code{all} keeps all the columns;
can also be a vector of column names.}
}
\value{
a dataframe with $diff = type_a - type_b$ in long format with diff,
type_a, and type_b as flux type, datetime, and any column specified in
\code{cols_keep}. Values of datetime and columns in \code{cols_keep} for diff row are
taken from type_a measurements.
}
\description{
to calculate a flux such as gross ecosystem production (GPP) or
transpiration (T) as the difference between other fluxes (such as
GPP = NEE - ER). Datetime and other variables to keep will be taken from the
\code{type1} measurement. Fluxes not used here (soilR, LRC or other) are not lost.
}
\examples{
data(co2_fluxes)
flux_diff(co2_fluxes, type, id_cols = "turfID", cols_keep = c("temp_soil"),
type_a = "NEE", type_b = "ER", diff_name = "GPP")
}
