% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify.R
\name{fm_simplify}
\alias{fm_simplify}
\title{Recursive curve simplification.}
\usage{
fm_simplify(x, eps = NULL, eps_rel = NULL, ...)
}
\arguments{
\item{x}{An \code{\link[=fm_segm]{fm_segm()}} object.}

\item{eps}{Absolute straightness tolerance. Default \code{NULL}, no constraint.}

\item{eps_rel}{Relative straightness tolerance. Default \code{NULL}, no
constraint.}

\item{...}{Currently unused.}
}
\value{
The simplified \code{\link[=fm_segm]{fm_segm()}} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Simplifies polygonal curve segments by joining nearly
co-linear segments.

Uses a variation of the binary splitting Ramer-Douglas-Peucker algorithm,
with an ellipse of half-width \code{eps} ellipse instead of a rectangle, motivated
by prediction ellipse for Brownian bridge.
}
\details{
Variation of Ramer-Douglas-Peucker.
Uses width epsilon ellipse instead of rectangle,
motivated by prediction ellipse for Brownian bridge.
}
\examples{
theta <- seq(0, 2 * pi, length.out = 1000)
(segm <- fm_segm(cbind(cos(theta), sin(theta)),
  idx = seq_along(theta)
))
(segm1 <- fm_simplify(segm, eps_rel = 0.1))
(segm2 <- fm_simplify(segm, eps_rel = 0.2))
plot(segm)
lines(segm1, col = 2)
lines(segm2, col = 3)

(segm <- fm_segm(cbind(theta, sin(theta * 4)),
  idx = seq_along(theta)
))
(segm1 <- fm_simplify(segm, eps_rel = 0.1))
(segm2 <- fm_simplify(segm, eps_rel = 0.2))
plot(segm)
lines(segm1, col = 2)
lines(segm2, col = 3)
}
\references{
Ramer, Urs (1972). "An iterative procedure for the polygonal approximation of
plane curves". \emph{Computer Graphics and Image Processing}. \strong{1} (3): 244–256.
\doi{10.1016/S0146-664X(72)80017-0}

Douglas, David; Peucker, Thomas (1973). "Algorithms for the reduction of
the number of points required to represent a digitized line or its
caricature". \emph{The Canadian Cartographer}. \strong{10} (2): 112–122.
\doi{10.3138/FM57-6770-U75U-7727}
}
\seealso{
Other object creation and conversion: 
\code{\link{fm_as_fm}()},
\code{\link{fm_as_lattice_2d}()},
\code{\link{fm_as_lattice_Nd}()},
\code{\link{fm_as_mesh_1d}()},
\code{\link{fm_as_mesh_2d}()},
\code{\link{fm_as_mesh_3d}()},
\code{\link{fm_as_segm}()},
\code{\link{fm_as_sfc}()},
\code{\link{fm_as_tensor}()},
\code{\link{fm_lattice_2d}()},
\code{\link{fm_lattice_Nd}()},
\code{\link{fm_mesh_1d}()},
\code{\link{fm_mesh_2d}()},
\code{\link{fm_segm}()},
\code{\link{fm_tensor}()}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\concept{object creation and conversion}
