% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_datasets.R
\docType{data}
\name{growth_ex}
\alias{growth_ex}
\title{Example growth data frame for small example}
\format{
A \code{sf} spatial tibble

\describe{
\item{ID}{Tree identification number. This identifies an individual tree and
can be used to connect trees between the two censuses.}
\item{sp}{Species of the individual}
\item{codes1}{Code for additional information on the stem during the first census: M means the main stem
of the individual tree and R means the stem was lost, but the tag was moved to another stem greater than DBH cutoff,
this stands for resprout.}
\item{dbh1}{Diameter at breast height of the tree in cm at the first census}
\item{dbh2}{Diameter at breast height of the tree in cm at the second census}
\item{growth}{Average annual growth between the two censuses in cm per year}
\item{codes2}{Codes at the second census}
\item{geometry}{Point location of the individual}
}
}
\usage{
growth_ex
}
\description{
This is an example growth data frame formed from two census data frames. In this case it is
made by combining \link{census_1_ex} and \link{census_2_ex}. The
individuals alive in both censuses were linked by their tree ID.
}
\examples{
library(ggplot2)
library(dplyr)
library(sf)
library(sfheaders)
library(blockCV)

growth_ex \%>\%
  ggplot() +
  geom_sf()

growth_ex \%>\%
  group_by(sp) \%>\%
  summarize(mean(growth))

# Add buffer
growth_spatial_ex <- growth_ex \%>\%
  add_buffer_variable(direction = "in", size = 1, region = study_region_ex)

# Add cross-validation folds
fold1 <- rbind(c(0, 0), c(5, 0), c(5, 5), c(0, 5), c(0, 0))
fold2 <- rbind(c(5, 0), c(10, 0), c(10, 5), c(5, 5), c(5, 0))
blocks <- bind_rows(
  sf_polygon(fold1),
  sf_polygon(fold2)
) \%>\%
  mutate(foldID = c(1, 2))

SpatialBlock_ex <- spatialBlock(
  speciesData = growth_ex,
  verbose = FALSE,
  k = 2,
  selection = "systematic",
  blocks = blocks
)

# Add foldID to data
growth_spatial_ex <- growth_spatial_ex \%>\%
  mutate(foldID = SpatialBlock_ex$foldID \%>\% as.factor())
}
\seealso{
\code{\link[=compute_growth]{compute_growth()}}

Other example data objects: 
\code{\link{blocks_ex}},
\code{\link{census_1_ex}},
\code{\link{census_2008_bw}},
\code{\link{census_2014_bw}},
\code{\link{census_2_ex}},
\code{\link{comp_bayes_lm_ex}},
\code{\link{focal_vs_comp_ex}},
\code{\link{growth_spatial_ex}},
\code{\link{growth_toy}},
\code{\link{species_bw}},
\code{\link{study_region_bw}},
\code{\link{study_region_ex}}
}
\concept{example data objects}
\keyword{datasets}
