% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_centsums.R
\name{show}
\alias{show}
\alias{show,centsums-method}
\title{Show a centsums object.}
\usage{
show(object)

\S4method{show}{centsums}(object)
}
\arguments{
\item{object}{a \code{centsums} object.}
}
\description{
Displays the centsums object.
}
\note{
The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.
}
\examples{
set.seed(123)
x <- rnorm(1000)
obj <- as.centsums(x, order=5)
obj
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
