% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fwb.array.R
\name{fwb.array}
\alias{fwb.array}
\title{Recover Bootstrap Weights}
\usage{
fwb.array(fwb.out)
}
\arguments{
\item{fwb.out}{an \code{fwb} object; the output of a call to \code{\link[=fwb]{fwb()}}.}
}
\value{
A matrix with \code{R} rows and \code{n} columns, where \code{R} is the number of bootstrap replications and \code{n} is the number of observations in \code{boot.out$data}.
}
\description{
\code{fwb.array()} returns the bootstrap weights generated by \code{\link[=fwb]{fwb()}}.
}
\details{
The original seed is used to recover the bootstrap weights before being reset.

Bootstrap weights are used in computing BCa confidence intervals by approximating the empirical influence function for each unit with respect to each parameter (see Examples).
}
\examples{
set.seed(123, "L'Ecuyer-CMRG")
data("infert")

fit_fun <- function(data, w) {
  fit <- glm(case ~ spontaneous + induced, data = data,
             family = "quasibinomial", weights = w)
  coef(fit)
}

fwb_out <- fwb(infert, fit_fun, R = 300,
               verbose = FALSE)

fwb_weights <- fwb.array(fwb_out)

dim(fwb_weights)

# Recover computed estimates:
est1 <- fit_fun(infert, fwb_weights[1, ])

stopifnot(all.equal(est1, fwb_out$t[1, ]))

# Compute empirical influence function:
empinf <- lm.fit(x = fwb_weights / ncol(fwb_weights),
                 y = fwb_out$t)$coefficients

empinf <- sweep(empinf, 2L, colMeans(empinf))
}
\seealso{
\code{\link[=fwb]{fwb()}} for performing the fractional weighted bootstrap; \pkgfun{boot}{boot.array} for the equivalent function in \pkg{boot}; \code{vignette("fwb-rep")} for information on replicability.
}
