% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{import_blockmeasures}
\alias{import_blockmeasures}
\title{Import blockmeasures}
\usage{
import_blockmeasures(
  files,
  num_plates = 1,
  plate_names = NULL,
  wellnames_sep = "",
  ...
)
}
\arguments{
\item{files}{Vector of filenames (as strings), each of which is a 
block-shaped file containing measures data. File formats
can be .csv, .xls, or .xlsx}

\item{num_plates}{Number of plates. If multiple plates uninterleave will be
used to separate blockmeasures into those plates accordingly}

\item{plate_names}{(optional) Names to put onto the plates when output}

\item{wellnames_sep}{String to use as separator for well names between 
rowname and column name}

\item{...}{Other arguments to pass to \link{read_blocks}, \link{uninterleave},
or \link{trans_block_to_wide}}
}
\value{
If \code{num_plates = 1}, a wide-shaped \code{data.frame}
        containing the measures data.
        
        if \code{num_plates} is greater than one, a list of 
        \code{data.frame}'s, where each \code{data.frame} is wide-shaped.
}
\description{
Function to import blockmeasures from files and return widemeasures
This function acts as a wrapper to call \link{read_blocks}, 
\link{uninterleave}, then \link{trans_block_to_wide} in one go
}
\details{
Common arguments that you may want to provide via \code{...}
             include:

             \code{startrow}, \code{endrow}, \code{startcol}, \code{endcol}, 
             \code{sheet} - specifying the location of design information 
             inside \code{files} to \link{read_blocks}
             
             \code{metadata} - specifying metadata to \link{read_blocks}
             
             See \link{read_blocks} for more details
             
             If you find yourself needing more control, you can run the 
             steps manually, first reading with \link{read_blocks}, 
             separating plates as needed with \link{uninterleave}, 
             then transforming to wide with \link{trans_block_to_wide}.
}
