% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini.R
\name{gemini.vertex}
\alias{gemini.vertex}
\title{Generate text from text with Gemini Vertex API}
\usage{
gemini.vertex(
  prompt = NULL,
  tokens = NULL,
  temperature = 1,
  maxOutputTokens = 8192,
  topK = 40,
  topP = 0.95,
  seed = 1234,
  timeout = 60
)
}
\arguments{
\item{prompt}{A character string containing the prompt for the Gemini model.}

\item{tokens}{A list containing the API URL and key from token.vertex() function.}

\item{temperature}{The temperature to use. Default is 1 value should be between 0 and 2
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{maxOutputTokens}{The maximum number of tokens to generate.
Default is 8192 and 100 tokens correspond to roughly 60-80 words.}

\item{topK}{The top-k value to use. Default is 40 value should be between 0 and 100
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{topP}{The top-p value to use. Default is 0.95 value should be between 0 and 1
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{seed}{The seed to use. Default is 1234 value should be integer
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{timeout}{Request timeout in seconds. Default is 60.}
}
\value{
A character string containing the generated text.
}
\description{
Generate text from text with Gemini Vertex API
}
\examples{
\dontrun{
# token should be created before this. using the token.vertex() function
prompt <- "What is sachins Jersey number?"
gemini.vertex(prompt, tokens)
}

}
\seealso{
https://ai.google.dev/docs/gemini_api_overview#text_input
}
