% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_docs.R
\name{gemini_docs}
\alias{gemini_docs}
\title{Summarize or analyze one or more local documents using Gemini API}
\usage{
gemini_docs(
  pdf_path,
  prompt,
  type = "PDF",
  api_key = Sys.getenv("GEMINI_API_KEY")
)
}
\arguments{
\item{pdf_path}{Path(s) to the local file(s). Can be a character vector.}

\item{prompt}{The prompt to send to Gemini (e.g., "Summarize these documents").}

\item{type}{File type. One of "PDF", "JavaScript", "Python", "TXT", "HTML", "CSS", "Markdown", "CSV", "XML", "RTF". Default is "PDF".}

\item{api_key}{Gemini API key. Defaults to \code{Sys.getenv("GEMINI_API_KEY")}.}
}
\value{
The summary or response text from Gemini.
}
\description{
Summarize, compare, or analyze the content of one or more local documents (PDF, TXT, HTML, etc.) using the Gemini API.
}
\details{
This function encodes one or more local files, sends them along with a prompt to the Gemini API, and returns the generated summary or response.
}
\examples{
\dontrun{
gemini_docs(
  pdf_path = c("doc1.pdf", "doc2.pdf"),
  prompt = "Compare these documents",
  type = "PDF"
)
}

}
\seealso{
https://ai.google.dev/gemini-api/docs/document-processing?lang=rest
}
