% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocs_raster.R
\name{geocs_raster}
\alias{geocs_raster}
\title{geocomplexity for spatial raster data based on geographical similarity}
\usage{
geocs_raster(r, order = 1, normalize = TRUE, similarity = 1, method = "spvar")
}
\arguments{
\item{r}{\code{SpatRaster} object or can be converted to \code{SpatRaster} by \code{terra::rast()}.}

\item{order}{(optional) The order of the adjacency object. Default is \code{1}.}

\item{normalize}{(optional) Whether to further normalizes the calculated geocomplexity.
Default is \code{TRUE}.}

\item{similarity}{(optional) When \code{similarity} is \code{1}, the similarity is calculated using
geographical configuration similarity, otherwise the cosine similarity is calculated.
Default is \code{1}.}

\item{method}{(optional) When \code{method} is \code{spvar}, variation of the similarity vector is
represented using spatial variance, otherwise shannon information entropy is used. Default
is \code{spvar}.}
}
\value{
A \code{SpatRaster} object
}
\description{
This function calculates geocomplexity for spatial raster data based on geographical similarity.
}
\note{
In contrast to the \code{geocs_vector()} function, the \code{geocs_raster()} performs operations
internally on raster data without providing additional wt object.
}
\examples{
library(terra)
m1 = matrix(c(3,3,3,3,1,3,
              3,3,3,2,1,2,
              3,3,3,1,2,1,
              1,3,2,2,2,2,
              2,2,2,1,1,2,
              1,2,1,1,1,1),
           nrow = 6,
           byrow = TRUE)
m1 = rast(m1)
names(m1) = 'sim1'
m2 = m1
set.seed(123456789)
values(m2) = values(m1) + runif(ncell(m1),-1,1)
names(m2) = 'sim2'
m = c(m1,m2)
gc1 = geocs_raster(m,1)
gc2 = geocs_raster(m,2)
gc1
plot(gc1)
gc2
plot(gc2)

}
