% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoflow.R
\docType{package}
\name{geoflow}
\alias{geoflow}
\alias{geoflow-package}
\title{Tools to Orchestrate and Run (Meta)Data Management Workflows}
\description{
Provides an engine to manage Spatial Data Infrastructures (SDI) and to orchestrate, run and automate 
geospatial (meta)data workflows in compliance with international standards (ISO, OGC, INSPIRE) with a range of actions such as 
data upload in spatial databases, publication in GeoServer and metadata publication in GeoNetwork. It includes actions 
to manage domain-specific resources usch ecological metadata (EML) and its publication on tools such as Metacat. It also allows to
publish data on cloud data infrastructures such as Zenodo or Dataverse. Through a pivot metadata model, geoflow allows to manage 
a unique source dataset metadata while offering a way to target various repositories for their publication. The execution of several 
actions will allow to cross-share (meta)data resources in each action performed, offering a way to bind resources between each other 
(eg. reference Zenodo DOIS in Geonetwork/Geoserver metadata, reference Geonetwork/Geoserver links in Zenodo or EML metadata). The use of
standardized configuration files allows fully reproducible workflows, in compliance with FAIR (Findable, Accessible, Interoperable, Reusable) 
principles.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-geoflow/geoflow}
  \item Report bugs at \url{https://github.com/r-geoflow/geoflow}
}

}
\author{
Emmanuel Blondel \email{emmanuel.blondel1@gmail.com}
}
