% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOFeatureCatalogueDescription.R
\docType{class}
\name{ISOFeatureCatalogueDescription}
\alias{ISOFeatureCatalogueDescription}
\title{ISOFeatureCatalogueDescription}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISOFeatureCatalogue
}
\description{
ISOFeatureCatalogueDescription

ISOFeatureCatalogueDescription
}
\examples{
  md <- ISOFeatureCatalogueDescription$new()
  md$setComplianceCode(FALSE)
  md$addLanguage("eng")
  md$setIncludedWithDataset(FALSE)
  
  cit = ISOCitation$new()
  contact = ISOContact$new()
  fcLink <- ISOOnlineResource$new()
  fcLink$setLinkage("http://somelink/featurecatalogue")
  contact$setOnlineResource(fcLink)
  rp = ISOResponsibleParty$new()
  rp$setContactInfo(contact)
  cit$addCitedResponsibleParty(rp)
  md$addFeatureCatalogueCitation(cit)
 
}
\references{
- ISO 19139 \url{https://schemas.isotc211.org/19139/-/gmd/1.0/gmd/#element_MD_FeatureCatalogueDescription}
  
  - ISO 19115-3 \url{https://schemas.isotc211.org/19115/-3/mrc/1.0/mrc/#element_MD_FeatureCatalogueDescription}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{catalogue}
\keyword{description}
\keyword{feature}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOAbstractContentInformation]{geometa::ISOAbstractContentInformation}} -> \code{ISOFeatureCatalogueDescription}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{complianceCode}}{complianceCode: logical}

\item{\code{language}}{language [0..*]: character}

\item{\code{locale}}{locale [0..*]: ISOLocale}

\item{\code{includedWithDataset}}{includedWithDataset: logical}

\item{\code{featureTypes}}{featureTypes [0..*]: GenericName #TODO?}

\item{\code{featureCatalogueCitation}}{featureCatalogueCitation [1..*]: ISOCitation}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOFeatureCatalogueDescription-new}{\code{ISOFeatureCatalogueDescription$new()}}
\item \href{#method-ISOFeatureCatalogueDescription-setComplianceCode}{\code{ISOFeatureCatalogueDescription$setComplianceCode()}}
\item \href{#method-ISOFeatureCatalogueDescription-addLanguage}{\code{ISOFeatureCatalogueDescription$addLanguage()}}
\item \href{#method-ISOFeatureCatalogueDescription-delLanguage}{\code{ISOFeatureCatalogueDescription$delLanguage()}}
\item \href{#method-ISOFeatureCatalogueDescription-addLocale}{\code{ISOFeatureCatalogueDescription$addLocale()}}
\item \href{#method-ISOFeatureCatalogueDescription-delLocale}{\code{ISOFeatureCatalogueDescription$delLocale()}}
\item \href{#method-ISOFeatureCatalogueDescription-setIncludedWithDataset}{\code{ISOFeatureCatalogueDescription$setIncludedWithDataset()}}
\item \href{#method-ISOFeatureCatalogueDescription-addFeatureCatalogueCitation}{\code{ISOFeatureCatalogueDescription$addFeatureCatalogueCitation()}}
\item \href{#method-ISOFeatureCatalogueDescription-delFeatureCatalogueCitation}{\code{ISOFeatureCatalogueDescription$delFeatureCatalogueCitation()}}
\item \href{#method-ISOFeatureCatalogueDescription-clone}{\code{ISOFeatureCatalogueDescription$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogueDescription-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogueDescription-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogueDescription$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogueDescription-setComplianceCode"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogueDescription-setComplianceCode}{}}}
\subsection{Method \code{setComplianceCode()}}{
Set compliance code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogueDescription$setComplianceCode(compliance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{compliance}}{compliance, object of class \link{logical}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogueDescription-addLanguage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogueDescription-addLanguage}{}}}
\subsection{Method \code{addLanguage()}}{
Adds language
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogueDescription$addLanguage(lang)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lang}}{lang}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogueDescription-delLanguage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogueDescription-delLanguage}{}}}
\subsection{Method \code{delLanguage()}}{
Deletes language
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogueDescription$delLanguage(lang)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lang}}{lang}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogueDescription-addLocale"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogueDescription-addLocale}{}}}
\subsection{Method \code{addLocale()}}{
Adds locale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogueDescription$addLocale(locale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{object of class \link{ISOLocale}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogueDescription-delLocale"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogueDescription-delLocale}{}}}
\subsection{Method \code{delLocale()}}{
Deletes locale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogueDescription$delLocale(locale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{object of class \link{ISOLocale}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogueDescription-setIncludedWithDataset"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogueDescription-setIncludedWithDataset}{}}}
\subsection{Method \code{setIncludedWithDataset()}}{
Set included with dataset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogueDescription$setIncludedWithDataset(include)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{include}}{include, object of class \link{logical}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogueDescription-addFeatureCatalogueCitation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogueDescription-addFeatureCatalogueCitation}{}}}
\subsection{Method \code{addFeatureCatalogueCitation()}}{
Adds feature catalogue citation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogueDescription$addFeatureCatalogueCitation(
  citation,
  uuid = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{citation, }}{object of class \link{ISOCitation}}

\item{\code{uuid}}{uuid}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogueDescription-delFeatureCatalogueCitation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogueDescription-delFeatureCatalogueCitation}{}}}
\subsection{Method \code{delFeatureCatalogueCitation()}}{
Deletes feature catalogue citation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogueDescription$delFeatureCatalogueCitation(
  citation,
  uuid = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{citation, }}{object of class \link{ISOCitation}}

\item{\code{uuid}}{uuid}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogueDescription-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogueDescription-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogueDescription$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
