% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-core-utilities.R
\name{load_raster_data}
\alias{load_raster_data}
\title{Load raster data from various sources}
\usage{
load_raster_data(
  input_data,
  pattern = "\\\\.(tif|tiff)$",
  recursive = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{input_data}{Character string (path to file or directory),
character vector of file paths, or a SpatRaster/Raster* object}

\item{pattern}{File pattern for directory search (default: tif files)}

\item{recursive}{Search subdirectories recursively}

\item{verbose}{Print progress messages}
}
\value{
List of terra SpatRaster objects
}
\description{
Universal function to load raster data from files, directories, or raster objects
with comprehensive error handling and validation.
}
\examples{
\dontrun{
# These examples require directory structures with multiple data files
# Load from directory with error handling
rasters <- load_raster_data("/path/to/raster/files")

# Load from file list with validation
rasters <- load_raster_data(c("file1.tif", "file2.tif"))
}

}
