% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-draw2.R
\name{scale_draw_manual}
\alias{scale_draw_manual}
\title{Scale for \code{draw} aesthetic}
\usage{
scale_draw_manual(
  ...,
  values,
  aesthetics = "draw",
  breaks = waiver(),
  na.value = NA
)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}
  \describe{
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{values}{A list of functions (including purrr-like lambda syntax) that
define how each cell's grob (graphical object) should be drawn.}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the
same time, via \code{aesthetics = c("colour", "fill")}.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}

\item{na.value}{The aesthetic value to use for missing (\code{NA}) values}
}
\description{
Draw a ggplot2 layer using a grob or a function.
}
\details{
If you want to combine the functionality of multiple geoms, it can
typically be achieved by preparing the data for each geom inside the
\verb{draw_*()} call and sending it off to the different geoms, collecting the
output in a \code{\link[grid:grid.grob]{grid::gList}} (a list of grobs) for \code{draw_group()} or a
\code{\link[grid:grid.grob]{grid::gTree}} (a grob containing multiple child grobs) for
\code{draw_panel()}.
}
\examples{
text <- grid::textGrob(
    "ggdraw",
    x = c(0, 0, 0.5, 1, 1),
    y = c(0, 1, 0.5, 0, 1),
    hjust = c(0, 0, 0.5, 1, 1),
    vjust = c(0, 1, 0.5, 0, 1)
)
ggplot(data.frame(x = 1, y = 2)) +
    geom_draw(text)
}
\seealso{
\url{https://ggplot2.tidyverse.org/reference/ggplot2-ggproto.html}
}
