% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcConnections.R
\name{calculateConnections}
\alias{calculateConnections}
\title{Calculate connections for a pedigree dataset}
\usage{
calculateConnections(ped, config = list())
}
\arguments{
\item{ped}{A data frame containing the pedigree data. Needs personID, momID, and dadID columns}

\item{config}{List of configuration parameters. Currently unused but passed through to internal helpers.}
}
\value{
A `data.frame` containing connection points and midpoints for graphical rendering. Includes:
  \itemize{
    \item `x_pos`, `y_pos`: positions of focal individual
    \item `x_dad`, `y_dad`, `x_mom`, `y_mom`: parental positions (if available)
    \item `x_spouse`, `y_spouse`: spousal positions (if available)
    \item `x_midparent`, `y_midparent`: midpoint between parents
    \item `x_mid_sib`, `y_mid_sib`: sibling group midpoint
    \item `x_mid_spouse`, `y_mid_spouse`: midpoint between spouses
  }
}
\description{
Computes graphical connection paths for a pedigree layout, including parent-child,
sibling, and spousal connections. Optionally processes duplicate appearances
of individuals (marked as `extra`) to ensure relational accuracy.
}
