% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scidcacrr.R
\name{scidca.crr}
\alias{scidca.crr}
\title{scidca.crr}
\usage{
\method{scidca}{crr}(
  fit,
  newdata = NULL,
  timepoint = "median",
  cmprsk = FALSE,
  modelnames = NULL,
  merge = FALSE,
  y.min = NULL,
  xstop = NULL,
  y.max = NULL,
  pyh = NULL,
  relcol = "#c01e35",
  irrelcol = "#0151a2",
  relabel = "Nomogram relevant",
  irrellabel = "Nomogram irrelevant",
  text.size = 4.5,
  text.col = "green",
  colbar = TRUE,
  threshold.text = FALSE,
  threshold.line = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  threshold.linetype = 2,
  threshold.linewidth = 1.2,
  threshold.linecol = "black",
  po.text.size = 4,
  po.text.col = "black",
  po.text.fill = "white",
  liftpec = NULL,
  rightpec = NULL,
  legend.position = c(0.85, 0.75)
)
}
\arguments{
\item{fit}{Fill in the model you want to analyze. Support survival analysis and logistic regression.}

\item{newdata}{If the decision curve of the validation set is to be analysed. Fill in the validation set data here.}

\item{timepoint}{If it is a survival analysis, fill in the point in time you need to study. The default is the median time.}

\item{cmprsk}{If it is a competitive risk model, select TRUE here.}

\item{modelnames}{Defines the name of the generated image model.}

\item{merge}{If true is selected it will merge the two long zones.}

\item{y.min}{The maximum value of the negative part of the picture. Generally defaults to positive values multiplied by 0.4.}

\item{xstop}{The maximum value of the X-axis of the picture.}

\item{y.max}{The maximum value of the Y-axis. The default value is the maximum net benefit.}

\item{pyh}{The height at which the bars are plotted cannot exceed y.min.}

\item{relcol}{The colour of the relevant part of the bar. The default is red.}

\item{irrelcol}{The colour of the irrelevant part of the bar. The default is blue.}

\item{relabel}{Relevance Tags.}

\item{irrellabel}{No relevant tags.}

\item{text.size}{Font size.}

\item{text.col}{The colour of the font.}

\item{colbar}{The default is true, and if false is selected, bar plotting is cancelled.}

\item{threshold.text}{The default is FALSE, if TRUE is selected, a text message for the threshold will be added.}

\item{threshold.line}{The default is FALSE, and if TRUE is selected, lines for the threshold will be added.}

\item{nudge_x}{Used to adjust the x-axis position of the point where the threshold is located.}

\item{nudge_y}{Used to adjust the y-axis position of the point where the threshold is located.}

\item{threshold.linetype}{The line shape of the threshold line.}

\item{threshold.linewidth}{The line width of the threshold line.}

\item{threshold.linecol}{The colour of the threshold line.}

\item{po.text.size}{The size of the threshold point text.}

\item{po.text.col}{The colour of the threshold point text.}

\item{po.text.fill}{The background of the threshold point text.}

\item{liftpec}{Threshold point left displacement.}

\item{rightpec}{Threshold point right displacement.}

\item{legend.position}{Set the position of the legend.}
}
\value{
A picture.
}
\description{
scidca.crr
}
