% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_fill_likert.R
\name{scale_fill_likert}
\alias{scale_fill_likert}
\alias{likert_pal}
\title{Colour scale for Likert-type plots}
\usage{
scale_fill_likert(
  name = waiver(),
  ...,
  pal = scales::brewer_pal(palette = "BrBG"),
  cutoff = NULL,
  aesthetics = "fill"
)

likert_pal(pal = scales::brewer_pal(palette = "BrBG"), cutoff = NULL)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title.
If \code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be omitted.}

\item{...}{Other arguments passed on to \code{discrete_scale()} to control name,
limits, breaks, labels and so forth.}

\item{pal}{A palette function taking a number of colours as entry and
returning a list of colours (see examples), ideally a diverging palette}

\item{cutoff}{Number of categories displayed negatively (see
\code{\link[=position_likert]{position_likert()}}) and therefore changing the center of the colour scale
(see examples).}

\item{aesthetics}{Character string or vector of character strings listing
the name(s) of the aesthetic(s) that this scale works with. This can be
useful, for example, to apply colour settings to the colour and fill
aesthetics at the same time, via \code{aesthetics = c("colour", "fill")}.}
}
\description{
This scale is similar to other diverging discrete colour scales, but allows
to change the "center" of the scale using \code{cutoff} argument, as used by
\code{\link[=position_likert]{position_likert()}}.
}
\examples{
library(ggplot2)
ggplot(diamonds) +
  aes(y = clarity, fill = cut) +
  geom_bar(position = "likert") +
  scale_x_continuous(label = label_percent_abs()) +
  xlab("proportion")

ggplot(diamonds) +
  aes(y = clarity, fill = cut) +
  geom_bar(position = "likert") +
  scale_x_continuous(label = label_percent_abs()) +
  xlab("proportion") +
  scale_fill_likert()

 ggplot(diamonds) +
  aes(y = clarity, fill = cut) +
  geom_bar(position = position_likert(cutoff = 1)) +
  scale_x_continuous(label = label_percent_abs()) +
  xlab("proportion") +
  scale_fill_likert(cutoff = 1)
}
