% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{linelist_hospital_outbreak}
\alias{linelist_hospital_outbreak}
\title{Line list of a fictional hospital outbreak (Data)}
\format{
A data frame with 8 rows and 9 columns:
\itemize{
\item \code{Patient} - Patient ID (0-7)
\item \code{ward_name_1} - Name of first ward where patient stayed
\item \code{ward_start_of_stay_1} - Start date of stay in first ward
\item \code{ward_end_of_stay_1} - End date of stay in first ward
\item \code{ward_name_2} - Name of second ward where patient stayed (if applicable)
\item \code{ward_start_of_stay_2} - Start date of stay in second ward (if applicable)
\item \code{ward_end_of_stay_2} - End date of stay in second ward (if applicable)
\item \code{pathogen_detection_1} - Date of first positive pathogen test
\item \code{pathogen_detection_2} - Date of second positive pathogen test (if applicable)
}

Patient details:
\itemize{
\item Patient 0: Index case (ICU), infected early on but detected June 30, 2024
\item Patient 1-2: ICU patients, found during initial screening
\item Patient 3: Case who moved from ICU to general ward prior to the detection of patient 0,
potentially linking both outbreak clusters. Detected during extended case search
\item Patient 4-6: General ward cases, found after Patient 3's detection
\item Patient 7: General ward case, detected post-discharge by GP, who notified the hospital
}
}
\usage{
linelist_hospital_outbreak
}
\description{
This hospital outbreak is inspired by typical hospital outbreaks with resistant 4MRGN bacterial pathogens.
These outbreaks start silent, since they are not initially apparent from the symptoms of the patient.
}
\examples{
library(dplyr)
library(tidyr)
library(ggplot2)

# Transform hospital outbreak line list to long format
linelist_hospital_outbreak |>
  pivot_longer(
    cols = starts_with("ward"),
    names_to = c(".value", "num"),
    names_pattern = "ward_(name|start_of_stay|end_of_stay)_([0-9]+)",
    values_drop_na = TRUE
  ) -> df_stays_long

linelist_hospital_outbreak |>
  pivot_longer(cols = starts_with("pathogen"), values_to = "date") -> df_detections_long

# Create Epi Gantt chart showing ward stays and test dates
ggplot(df_stays_long) +
  geom_epigantt(aes(y = Patient, xmin = start_of_stay, xmax = end_of_stay, color = name)) +
  geom_point(aes(y = Patient, x = date, shape = "Date of pathogen detection"),
    data = df_detections_long
  ) +
  scale_y_discrete_reverse() +
  theme_bw() +
  theme(legend.position = "bottom")

}
\keyword{datasets}
