% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_continuous_diverging.R
\name{scale_continuous_diverging}
\alias{scale_continuous_diverging}
\alias{scale_x_continuous_diverging}
\alias{scale_y_continuous_diverging}
\title{Diverging continuous scales for diverging bar charts with symmetrical limits}
\usage{
scale_x_continuous_diverging(
  name = waiver(),
  limits = NULL,
  labels = NULL,
  transform = "identity",
  ...,
  breaks = waiver(),
  n.breaks = NULL,
  expand = waiver(),
  position = "bottom"
)

scale_y_continuous_diverging(
  name = waiver(),
  limits = NULL,
  labels = NULL,
  transform = "identity",
  ...,
  breaks = waiver(),
  n.breaks = NULL,
  expand = waiver(),
  position = "left"
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{limits}{Numeric vector of length two providing limits of the scale.
If \code{NULL} (the default), limits are automatically computed to be
symmetrical around zero.}

\item{labels}{Either \code{waiver()}, a character vector or a function that takes the breaks
as input and returns labels as output. By default, absolute values are displayed or passed to the label function.}

\item{transform}{Defaults to "identity". Use "reverse" to invert the scale.
Especially useful to flip the direction of diverging bar charts.}

\item{...}{Other arguments passed on to \verb{scale_(x|y)_continuous()}}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:new_transform]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Note that for position scales, limits are provided after scale expansion.
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{n.breaks}{An integer guiding the number of major breaks. The algorithm
may choose a slightly different number to ensure nice break labels. Will
only have an effect if \code{breaks = waiver()}. Use \code{NULL} to use the default
number of breaks given by the transformation.}

\item{expand}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
}
\value{
A \code{ggplot2} scale object that can be added to a plot.
}
\description{
These scales automatically create symmetrical limits around a centre point (zero by default).
They're useful for diverging continuous variables where the visual encoding should
be balanced around a center point, such as positive and negative values.
They are intended to be used with \code{\link[=geom_bar_diverging]{geom_bar_diverging()}}, \code{\link[=geom_area_diverging]{geom_area_diverging()}} and \code{\link[=stat_diverging]{stat_diverging()}}.
}
\examples{
library(ggplot2)

# Create sample data with positive and negative values
df <- data.frame(
  x = c(-5, -2, 0, 3, 7),
  y = c(2, -1, 0, -3, 5)
)

# Basic usage
ggplot(df, aes(x, y)) +
  geom_point() +
  scale_x_continuous_diverging() +
  scale_y_continuous_diverging()

}
\seealso{
\code{\link[=geom_bar_diverging]{geom_bar_diverging()}}, \code{\link[=geom_area_diverging]{geom_area_diverging()}}, \code{\link[=stat_diverging]{stat_diverging()}}
}
