% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_metadata.R
\name{update_metadata}
\alias{update_metadata}
\title{Update the description of a \code{git2rdata} object}
\usage{
update_metadata(file, root = ".", field_description, name, title, description)
}
\arguments{
\item{file}{the name of the git2rdata object. Git2rdata objects cannot
have dots in their name. The name may include a relative path. \code{file} is a
path relative to the \code{root}.
Note that \code{file} must point to a location within \code{root}.}

\item{root}{The root of a project. Can be a file path or a \code{git-repository}.
Defaults to the current working directory (\code{"."}).}

\item{field_description}{a named character vector with the new descriptions
for the fields.
The names of the vector must match the variable names.}

\item{name}{a character string with the new table name of the object.}

\item{title}{a character string with the new title of the object.}

\item{description}{a character string with the new description of the object.}
}
\description{
Allows to update the description of the fields, the table name, the title,
and the description of a \code{git2rdata} object.
All arguments are optional.
Setting an argument to \code{NA} or an empty string will remove the corresponding
field from the metadata.
}
\seealso{
Other storage: 
\code{\link{display_metadata}()},
\code{\link{list_data}()},
\code{\link{prune_meta}()},
\code{\link{read_vc}()},
\code{\link{relabel}()},
\code{\link{rename_variable}()},
\code{\link{rm_data}()},
\code{\link{verify_vc}()},
\code{\link{write_vc}()}
}
\concept{storage}
