% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg.R
\name{.validate_and_prepare_gkwreg_diagnostics}
\alias{.validate_and_prepare_gkwreg_diagnostics}
\title{Validate inputs and prepare diagnostic data for gkwreg plots}
\usage{
.validate_and_prepare_gkwreg_diagnostics(
  x,
  which,
  caption,
  type = c("quantile", "pearson", "deviance"),
  family = NULL,
  nsim = 100,
  level = 0.9,
  use_ggplot = FALSE,
  arrange_plots = FALSE,
  sample_size = NULL,
  theme_fn = ggplot2::theme_minimal
)
}
\arguments{
\item{x}{A fitted model object of class "gkwreg"}

\item{which}{Integer vector specifying which plots to produce}

\item{caption}{Character vector of plot captions}

\item{type}{Character string specifying residual type}

\item{family}{Character string specifying distribution family}

\item{nsim}{Number of simulations for envelope calculation}

\item{level}{Confidence level for envelope}

\item{use_ggplot}{Logical; whether to use ggplot2}

\item{arrange_plots}{Logical; whether to arrange multiple plots}

\item{sample_size}{Integer or NULL; sample size for large datasets}

\item{theme_fn}{ggplot2 theme function}
}
\value{
A list containing diagnostic data and model information
}
\description{
Validate inputs and prepare diagnostic data for gkwreg plots
}
\keyword{internal}
