% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_do.R
\name{cr_build_make}
\alias{cr_build_make}
\title{Make a Cloud Build object out of a cloudbuild.yml file}
\usage{
cr_build_make(
  yaml,
  source = NULL,
  timeout = NULL,
  images = NULL,
  artifacts = NULL,
  options = NULL,
  substitutions = NULL,
  availableSecrets = NULL,
  serviceAccount = NULL,
  logsBucket = NULL
)
}
\arguments{
\item{yaml}{A \code{Yaml} object created from \link{cr_build_yaml} or a file location of a .yaml/.yml cloud build file}

\item{source}{A \link{Source} object specifying the location of the source files to build, usually created by \link{cr_build_source}}

\item{timeout}{Amount of time that this build should be allowed to run, to second}

\item{images}{A list of images to be pushed upon the successful completion of all build}

\item{artifacts}{Artifacts that may be built via \link{cr_build_yaml_artifact}}

\item{options}{Options to pass to a Cloud Build}

\item{substitutions}{Substitutions data for `Build` resource}

\item{availableSecrets}{Secret Manager objects built by \link{cr_build_yaml_secrets}}

\item{serviceAccount}{service account email to be used for the build}

\item{logsBucket}{The gs:// location of a bucket to put logs in}
}
\description{
This creates a \link{Build} object via the standard cloudbuild.yaml format
}
\examples{
cloudbuild <- system.file("cloudbuild/cloudbuild.yaml",
  package = "googleCloudRunner"
)
cr_build_make(cloudbuild)
}
\seealso{
\url{https://cloud.google.com/build/docs/build-config-file-schema}

Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{RepoSource}()},
\code{\link{Source}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_list}()},
\code{\link{cr_build_logs}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_targets}()},
\code{\link{cr_build_upload_gcs}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml_secrets}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
