% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_checks.R
\name{ensure_matrix_symmetry}
\alias{ensure_matrix_symmetry}
\alias{truncate_zeros}
\alias{ensure_matrix_symmetry_and_truncate_zeros}
\title{Ensure numerical matrix symmetry/zero values}
\usage{
ensure_matrix_symmetry(M, checkTol = Inf, alert = NULL)

truncate_zeros(M, tol = get_small_tol())

ensure_matrix_symmetry_and_truncate_zeros(
  M,
  tol = get_small_tol(),
  checkTol = Inf
)
}
\arguments{
\item{M}{Numeric square matrix.}

\item{checkTol}{Positive scalar. If the maximum absolute difference between \code{M}
and \code{t(M)} is larger, show a warning.}

\item{alert}{Passed to \code{get_alert_function}: \code{NULL} or \code{TRUE} to read the option value,
\code{FALSE} to return a dummy function, or a function that takes an arbitrary number of strings as arguments (e.g. \code{stop()}).}

\item{tol}{All entries with absolute value below this value are truncated to zero.}
}
\value{
The adjusted value of \code{M}.
}
\description{
Ensures the symmetry of a square matrix by averaging it with its transpose.
Optionally verifies that the matrix was close to symmetric before.

Makes sure zeros are "numerically zero", by truncating all small values.
}
\seealso{
Other input validation functions:
\code{\link{checkGamma}()},
\code{\link{check_graph}()},
\code{\link{check_partial_matrix_and_graph}()}
}
\concept{inputChecks}
