% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_param_MLE.R
\name{fmpareto_HR_MLE}
\alias{fmpareto_HR_MLE}
\title{Parameter fitting for multivariate Huesler-Reiss Pareto distribution}
\usage{
fmpareto_HR_MLE(
  data,
  p = NULL,
  cens = FALSE,
  init = NULL,
  fixParams = integer(0),
  useTheta = TRUE,
  maxit = 100,
  graph = NULL,
  optMethod = "BFGS",
  nAttemptsFixInit = 3
)
}
\arguments{
\item{data}{Numeric \nxd matrix, where \code{n} is the
number of observations and \code{d} is the number of dimensions.}

\item{p}{Numeric scalar between 0 and 1 or \code{NULL}. If \code{NULL} (default),
it is assumed that the \code{data} is already on a multivariate Pareto scale. Else,
\code{p} is used as the probability in \code{\link[=data2mpareto]{data2mpareto()}} to standardize the data.}

\item{cens}{Logical scalar. If true, then censored likelihood contributions are used for
components below the threshold. This is computationally expensive and by default \code{cens = FALSE}.}

\item{init}{Numeric vector or numeric matrix. Initial parameter values in the optimization.
If \code{NULL}, the empirical variogram is used instead. Otherwise should be a numeric
vector with one entry per edge in \code{graph}, or a complete variogram/precision matrix.}

\item{fixParams}{Numeric or logical vector. Indices of the parameter vectors that are kept
fixed (identical to \code{init}) during the optimization. Default is \code{integer(0)}.}

\item{useTheta}{Logical. Whether to perform the MLE optimization in terms of Theta or Gamma.}

\item{maxit}{Positive integer. The maximum number of iterations in the optimization.}

\item{graph}{Graph object from \code{igraph} package or \code{NULL} (implying the complete graph).}

\item{optMethod}{String. A valid optimization method used by the function
\link[stats:optim]{stats::optim}. By default, \code{method = "BFGS"}.}

\item{nAttemptsFixInit}{Numeric. If \code{useTheta=TRUE} and the initial parameter \code{init} is not valid,
attempt to fix it first by making sure all off-diagonal entries are negative and then adding some random noise
at most this many times.}
}
\value{
List consisting of:
\item{\code{convergence}}{Logical. Indicates whether the optimization converged or not.}
\item{\code{Gamma}}{Numeric \verb{d x d} matrix. Fitted variogram matrix.}
\item{\code{Theta}}{Numeric \verb{d x d} matrix. Fitted precision matrix.}
\item{\code{par}}{Numeric vector. Optimal parameters, including fixed parameters.}
\item{\code{par_opt}}{Numeric. Optimal parameters, excluding fixed parameters.}
\item{\code{nllik}}{Numeric. Optimal value of the negative log-likelihood function.}
\item{\code{hessian}}{Numeric matrix. Estimated Hessian matrix of the estimated parameters.}
}
\description{
Fits the parameters of a multivariate Huesler-Reiss Pareto distribution
using (censored) maximum likelihood estimation.
}
\details{
Only the parameters corresponding to edges in \code{graph} are optimized, the remaining
entries are implied by the graphical structure. If \code{graph} is \code{NULL}, the complete graph is used.
The optimization is done either in terms of the variogram (Gamma) or precision matrix (Theta),
depending on the value of \code{useTheta}. If \code{graph} is non-decomposable,
\code{useTheta=TRUE} is significantly faster, otherwise they are similar in performance.
}
\seealso{
Other parameter estimation methods:
\code{\link{data2mpareto}()},
\code{\link{emp_chi}()},
\code{\link{emp_chi_multdim}()},
\code{\link{emp_vario}()},
\code{\link{emtp2}()},
\code{\link{fmpareto_graph_HR}()},
\code{\link{loglik_HR}()}
}
\concept{parameterEstimation}
