% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_flights.R
\name{getFlightDelayData}
\alias{getFlightDelayData}
\title{Get filtered flight delays}
\usage{
getFlightDelayData(
  what = c("delays", "IATAs", "dates"),
  airportFilter = c("all", "tcCluster", "tcAll"),
  dateFilter = c("all", "tcTrain", "tcTest", "tcAll"),
  delayFilter = c("totals", "arrivals", "departures")[1]
)
}
\arguments{
\item{what}{Whether to get the array of delays (numerical),
or just the vector of airport codes (\code{"IATAs"}, strings)
or dates (as strings). Specify exactly one.}

\item{airportFilter}{Which airports to include. Specify exactly one. See details below.}

\item{dateFilter}{Which dates to include. Specify exactly one. See details below.}

\item{delayFilter}{Which kinds of delays to include. Specify one or more.
Possible values are \code{"arrivals"}, \code{"departures"}, and \code{"totals"} (computed as sum of arrival and departure delays).}
}
\value{
If \code{what="IATAs"} or \code{what="dates"}, a character vector.
If required, it can be converted to \code{\link{Date}} objects using \code{\link[=as.Date]{as.Date()}}.

If \code{what="delays"}, a three-dimensional array or two-dimensional matrix,
with dimensions corresponding to dates, airports, and delay types.
}
\description{
Get filtered flight delay data, containing only a selection of dates and airports.
Currently, all possible selections correspond to the case study in \localCiteT{hen2022}.
}
\details{
The provided lists of airports and dates correspond to the ones used in
the case study of \localCiteT{hen2022}.
The argument \code{airportFilter="tcCluster"} corresponds to the airports in the analyzed "Texas Cluster",
\code{airportFilter="tcAll"} corresponds to all airports used in the previous clustering step,
\code{airportFilter="all"} corresponds to all airports in the dataset.

Similarly, \code{dateFilter="tcTrain"} selects the dates from the training set,
\code{dateFilter="tcTest"} the ones from the test/validation set.
To get the union of these sets, specify \code{dateFilter="tcAll"}.
To get all dates in the dataset (possibly more than for "tcAll"),
specify \code{dateFilter="all"}.
}
\references{
\insertAllCited{}
}
\seealso{
Other flight data related topics:
\code{\link{flightCountMatrixToConnectionList}()},
\code{\link{flights}},
\code{\link{getFlightGraph}()},
\code{\link{plotFlights}()}
}
\concept{flightData}
