% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period.R
\name{as_period}
\alias{as_period}
\alias{as_period.default}
\alias{as_period.Date}
\alias{as_period.POSIXt}
\alias{as_period.character}
\alias{as_period.factor}
\title{Coerce an object to period}
\usage{
as_period(x, n, ...)

\method{as_period}{default}(x, n = 1L, offset = 0L, ...)

\method{as_period}{Date}(x, n = 1L, offset = 0L, ...)

\method{as_period}{POSIXt}(x, n = 1L, offset = 0L, ...)

\method{as_period}{character}(x, n = 1L, offset = 0L, ...)

\method{as_period}{factor}(x, n = 1L, offset = 0L, ...)
}
\arguments{
\item{x}{An \R object:
\itemize{
\item Character input is first parsed using \code{as.Date()}.
\item POSIXt inputs are converted with the timezone respected.
}}

\item{n}{\verb{[integer]}

Number of days that are being grouped.}

\item{...}{Only used For character input where additional arguments are passed through
to \code{as.Date()}.}

\item{offset}{\verb{[integer]} or \verb{[date]}

Value you wish to start counting periods from relative to the Unix Epoch:
\itemize{
\item For integer values this is stored scaled by \code{n}
(\code{offset <- as.integer(offset) \%\% n}).
\item For date values this is first converted to an integer offset
(\code{offset <- floor(as.numeric(offset))}) and then scaled via \code{n} as above.
}}
}
\value{
A \verb{<grates_period>} object.
}
\description{
\code{as_period()} is a generic for coercing input in to \verb{<grates_period>}.
}
\note{
Internally \code{grates_period} objects are stored as the integer number, starting
at 0L, of periods since the Unix Epoch (1970-01-01) and a specified offset.
Here periods are taken to mean groupings of \code{n} consecutive days.
}
\examples{
as_period("2019-05-03")
as_period("2019-05-03", n = 2, offset = 1)
as_period(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"), n = 10)
as_period(as.Date("2020-03-02"), n = 2L, offset = as.Date("2020-03-01"))

}
\seealso{
\code{as.Date()}
}
