% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_point.R
\name{convert_to_point}
\alias{convert_to_point}
\title{Convert Geometries to Points and Reproject to WGS84}
\usage{
convert_to_point(data, target_crs = 4326)
}
\arguments{
\item{data}{An sf object containing geometries.}

\item{target_crs}{The target coordinate reference system (default is WGS84, EPSG:4326).}
}
\value{
An sf object with point geometries reprojected to the target CRS.
}
\description{
This function converts geometries (points, lines, polygons) to their centroid points and reprojects them to WGS84.
}
\examples{
\donttest{
  library(sf)
  library(dplyr)

  # Create example data with a CRS
  lines <- st_sf(
    id = 1:5,
    geometry = st_sfc(
      st_linestring(matrix(c(0,0, 1,1), ncol=2, byrow=TRUE)),
      st_linestring(matrix(c(1,1, 2,2), ncol=2, byrow=TRUE)),
      st_linestring(matrix(c(2,2, 3,3), ncol=2, byrow=TRUE)),
      st_linestring(matrix(c(3,3, 4,4), ncol=2, byrow=TRUE)),
      st_linestring(matrix(c(4,4, 5,5), ncol=2, byrow=TRUE))
    ),
    crs = 4326 # Assign WGS84 CRS
  )

  # Convert geometries to points
  points <- convert_to_point(lines)
}
}
