% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtsummary_tests.R
\name{gtsummary_test}
\alias{gtsummary_test}
\alias{fisher.simulate.p}
\title{Additional tests for \code{gtsummary}}
\usage{
fisher.simulate.p(data, variable, by, ...)
}
\arguments{
\item{data}{A data set.}

\item{variable}{Name of the variable to test.}

\item{by}{Name of the by variable.}

\item{...}{Unused.}
}
\description{
See \link[gtsummary:tests]{gtsummary::tests} for more details on how defining custom tests.
\code{fisher.simulate.p()} implements Fisher test with computation of p-values by
Monte Carlo simulation in larger than 2×2 tables (see
\code{\link[stats:fisher.test]{stats::fisher.test()}}).
}
\examples{
\dontshow{if (rlang::is_installed("gtsummary")) withAutoprint(\{ # examplesIf}
library(gtsummary)
trial |>
  tbl_summary(include = grade, by = trt) |>
  add_p(test = all_categorical() ~ "fisher.simulate.p")
\dontshow{\}) # examplesIf}
}
\keyword{htest}
