context("Check if api functions are working correctly")

httptest::with_mock_api({
  test_that("Retrieve by id function is working correctly", {
    result <- get_item_by_id(8863)
    expected <- list(
      by = "dhouston",
      descendants = 71,
      id = 8863,
      kids = c(9224, 8876),
      score = 104,
      time = as.POSIXct(1175714200, origin = "1970-01-01"),
      title = "My YC app: Dropbox - Throw away your USB drive",
      type = "story",
      url = "http://www.getdropbox.com/u/2/screencast.html"
    )
    class(expected) <- "hn_item"

    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve by username function is working correctly", {
    result <- get_user_by_username("tomek")
    expected <- list(
      created = as.POSIXct(1185850697, origin = "1970-01-01"),
      delay = 0,
      id = "tomek",
      karma = 6,
      submitted = c(1194446, 677151, 314161, 292943, 273424, 257198, 236583, 48012, 46649, 46647, 44939, 44009, 43894, 43886, 42193, 42192, 42177, 41987, 38790, 37822)
    )
    class(expected) <- "hn_user"
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve max item id function is working correctly", {
    result <- get_max_item_id()
    expected <- 21301342
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve top stories id function is working correctly", {
    result <- get_top_stories_ids()
    expected <- c(21299546, 21278790, 21300188, 21298383, 21300748, 21299960, 21299768, 21297462, 21300191, 21299610, 21300476, 21292291, 21298227, 21298233, 21299102, 21299032, 21298472, 21299086, 21293941, 21298920, 21300962, 21279018, 21297639, 21298341, 21286379, 21299127, 21293859, 21298637, 21298830, 21298470, 21297499, 21300052, 21297868, 21293734, 21300529, 21297893, 21300822, 21298306, 21290388, 21297876, 21300336, 21300689, 21278755, 21297880, 21298399, 21301119, 21293505, 21300669, 21289827, 21293891, 21298878, 21295942, 21298304, 21294354, 21299318, 21300005, 21289832, 21300817, 21299321, 21298006, 21296167, 21294976, 21297165, 21298394, 21295079, 21293132, 21298729, 21299468, 21286640, 21298620, 21292497, 21293452, 21283835, 21278715, 21295149, 21288185, 21296261, 21280205, 21285419, 21295729, 21281525, 21292205, 21299008, 21295489, 21297789, 21286192, 21295097, 21294621, 21285329, 21280918, 21290881, 21297664, 21293827, 21278786, 21292191, 21278924, 21284770, 21299722, 21291510, 21288988, 21295516, 21299277, 21296323, 21288029, 21298692, 21280041, 21296622, 21290813, 21299171, 21287944, 21288663, 21277580, 21299762, 21281025, 21293189, 21288195, 21290306, 21293497, 21290785, 21297178, 21293852, 21286898, 21292860, 21293397, 21295117, 21298075, 21281042, 21291579, 21291518, 21289237, 21279756, 21280202, 21291131, 21287736, 21280092, 21290200, 21289531, 21292476, 21280429, 21281411, 21293544, 21295853, 21289456, 21292445, 21279945, 21283791, 21281724, 21286319, 21283838, 21279366, 21287924, 21298369, 21280352, 21289251, 21292472, 21282647, 21291342, 21283994, 21289104, 21288415, 21293838, 21283861, 21298489, 21278630, 21287275, 21287498, 21286104, 21288280, 21282680, 21282009, 21296565, 21295575, 21278839, 21296855, 21290643, 21282699, 21296259, 21288060, 21278705, 21285145, 21290589, 21278360, 21287267, 21298385, 21278948, 21295849, 21289074, 21286806, 21278048, 21289920, 21279725, 21298163, 21286973, 21280238, 21291935, 21277690, 21289201, 21297279, 21285728, 21289943, 21285146, 21288807, 21297554, 21294499, 21278009, 21296612, 21284387, 21281533, 21285127, 21294187, 21279752, 21289337, 21286574, 21286074, 21295368, 21293025, 21292999, 21296417, 21292461, 21283644, 21289899, 21284962, 21297221, 21290582, 21286229, 21280256, 21297564, 21283651, 21283216, 21282179, 21287354, 21296954, 21292536, 21284255, 21284466, 21294327, 21281195, 21296799, 21285376, 21292533, 21289786, 21281296, 21295932, 21297134, 21283528, 21281541, 21289605, 21292281, 21297053, 21295756, 21294569, 21293272, 21291842, 21296951, 21282609, 21296271, 21286537, 21278269, 21296197, 21295305, 21286054, 21296499, 21295234, 21297199, 21291210, 21285609, 21288660, 21293281, 21290657, 21287955, 21286200, 21292986, 21294419, 21283635, 21288421, 21294286, 21289563, 21295556, 21298217, 21290839, 21278960, 21287412, 21293350, 21286982, 21296294, 21292793, 21282982, 21278152, 21294783, 21284032, 21285907, 21285638, 21280087, 21279778, 21289443, 21295874, 21284241, 21293606, 21295708, 21282110, 21284896, 21286177, 21278627, 21283074, 21282372, 21292650, 21292605, 21288268, 21294932, 21294882, 21294802, 21290508, 21294519, 21286597, 21291241, 21289637, 21290096, 21284312, 21279515, 21290651, 21290602, 21285032, 21287642, 21287599, 21292881, 21287526, 21283221, 21292554, 21277804, 21279720, 21288158, 21291593, 21279022, 21285807, 21289941, 21285793, 21279568, 21294613, 21290739, 21290564, 21281192, 21292112, 21282843, 21281024, 21281640, 21298539, 21284987, 21287710, 21284567, 21289570, 21289560, 21289313, 21286991, 21286871, 21283988, 21286694, 21289050, 21286492, 21286291, 21281783, 21288511, 21288265, 21278342, 21283153, 21287344, 21293588, 21289611, 21286674, 21286262, 21286254, 21277729, 21284159, 21296033, 21284912, 21284840, 21283382, 21283189, 21284050, 21282612, 21282556, 21288048, 21283398, 21278734, 21292706, 21280066, 21277935, 21284743, 21279016, 21282812, 21280295, 21283421, 21285083, 21280302, 21279655, 21286435, 21278253, 21288544, 21284765, 21287957, 21287337, 21292727, 21279206, 21278171, 21285543, 21290186, 21292630, 21294040, 21292713, 21291282, 21296674, 21293853, 21292991, 21298775, 21288190, 21288420, 21278194, 21280337, 21293550, 21295629)
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve top stories function is working correctly", {
    result <- get_top_stories(2)
    expected <- list()
    item1 <- list(
        by = "susam",
        descendants = 142,
        id = 21299546,
        kids = c(21300147, 21302020),
        score = 661,
        time = as.POSIXct(1571505668, origin = "1970-01-01"),
        title = "Structure and Interpretation of Computer Programs (1996) [pdf]",
        type = "story",
        url = "https://opendocs.github.io/sicp/sicp.pdf"
    )
    class(item1) <- "hn_item"

    item2 <- list(
        by = "codesections",
        descendants = 122,
        id = 21278790,
        kids = c(21301138, 21300939),
        score = 199,
        time = as.POSIXct(1571284726, origin = "1970-01-01"),
        title = "Loopless Programming",
        type = "story",
        url = "https://code.jsoftware.com/wiki/Vocabulary/Loopless"
    )
    class(item2) <- "hn_item"
    expected <- list(item1, item2)
    expect_equal(result, expected)
  })
})


httptest::with_mock_api({
  test_that("Retrieve new stories id function is working correctly", {
    result <- get_new_stories_ids()
    expected <- c(21301388, 21301382, 21301374, 21301361, 21301323, 21301314, 21301313, 21301309, 21301308, 21301269, 21301261, 21301259, 21301254, 21301252, 21301247, 21301219, 21301212, 21301204, 21301181, 21301164, 21301163, 21301147, 21301119, 21301118, 21301114, 21301108, 21301091, 21301089, 21301088, 21301067, 21301063, 21301062, 21301039, 21301030, 21301027, 21301014, 21300999, 21300992, 21300988, 21300971, 21300962, 21300961, 21300946, 21300929, 21300920, 21300902, 21300901, 21300898, 21300875, 21300871, 21300860, 21300847, 21300840, 21300830, 21300826, 21300822, 21300820, 21300818, 21300817, 21300815, 21300811, 21300808, 21300805, 21300804, 21300803, 21300797, 21300793, 21300790, 21300788, 21300782, 21300780, 21300779, 21300763, 21300755, 21300748, 21300743, 21300737, 21300728, 21300707, 21300689, 21300669, 21300658, 21300650, 21300641, 21300639, 21300638, 21300630, 21300627, 21300611, 21300601, 21300598, 21300589, 21300561, 21300559, 21300553, 21300529, 21300511, 21300509, 21300483, 21300481, 21300476, 21300458, 21300449, 21300435, 21300430, 21300422, 21300411, 21300410, 21300404, 21300401, 21300394, 21300381, 21300378, 21300336, 21300331, 21300316, 21300313, 21300293, 21300281, 21300268, 21300224, 21300218, 21300214, 21300207, 21300201, 21300197, 21300191, 21300188, 21300179, 21300141, 21300124, 21300102, 21300052, 21300050, 21300047, 21300046, 21300032, 21300013, 21300008, 21300005, 21300001, 21299998, 21299992, 21299983, 21299982, 21299960, 21299957, 21299949, 21299943, 21299921, 21299911, 21299900, 21299899, 21299897, 21299889, 21299856, 21299853, 21299845, 21299844, 21299813, 21299811, 21299800, 21299781, 21299777, 21299768, 21299767, 21299762, 21299754, 21299740, 21299738, 21299732, 21299722, 21299721, 21299693, 21299692, 21299662, 21299660, 21299637, 21299633, 21299624, 21299615, 21299614, 21299610, 21299604, 21299593, 21299590, 21299588, 21299572, 21299571, 21299565, 21299564, 21299559, 21299546, 21299538, 21299537, 21299536, 21299534, 21299513, 21299507, 21299502, 21299494, 21299468, 21299458, 21299452, 21299436, 21299431, 21299416, 21299410, 21299406, 21299402, 21299396, 21299391, 21299383, 21299381, 21299376, 21299370, 21299349, 21299322, 21299321, 21299318, 21299298, 21299285, 21299283, 21299277, 21299275, 21299274, 21299272, 21299268, 21299265, 21299259, 21299252, 21299238, 21299237, 21299231, 21299227, 21299224, 21299218, 21299206, 21299197, 21299189, 21299171, 21299157, 21299156, 21299147, 21299127, 21299120, 21299112, 21299110, 21299108, 21299102, 21299100, 21299096, 21299095, 21299086, 21299070, 21299065, 21299051, 21299047, 21299032, 21299020, 21299016, 21299014, 21299008, 21298999, 21298988, 21298987, 21298983, 21298964, 21298963, 21298959, 21298957, 21298938, 21298932, 21298920, 21298909, 21298898, 21298885, 21298878, 21298876, 21298869, 21298842, 21298832, 21298830, 21298811, 21298808, 21298796, 21298780, 21298779, 21298775, 21298768, 21298751, 21298729, 21298721, 21298701, 21298692, 21298682, 21298680, 21298679, 21298675, 21298664, 21298662, 21298656, 21298641, 21298639, 21298637, 21298629, 21298625, 21298620, 21298591, 21298590, 21298587, 21298574, 21298565, 21298557, 21298555, 21298553, 21298539, 21298535, 21298531, 21298530, 21298516, 21298489, 21298487, 21298479, 21298472, 21298470, 21298464, 21298457, 21298428, 21298422, 21298421, 21298419, 21298406, 21298404, 21298399, 21298394, 21298385, 21298383, 21298381, 21298379, 21298375, 21298374, 21298373, 21298369, 21298368, 21298360, 21298349, 21298345, 21298341, 21298340, 21298306, 21298304, 21298280, 21298239, 21298238, 21298233, 21298227, 21298218, 21298217, 21298213, 21298205, 21298190, 21298183, 21298179, 21298172, 21298163, 21298160, 21298138, 21298131, 21298122, 21298117, 21298114, 21298109, 21298108, 21298101, 21298093, 21298080, 21298076, 21298075, 21298070, 21298064, 21298060, 21298057, 21298049, 21298048, 21298030, 21298028, 21298019, 21298006, 21297995, 21297994, 21297986, 21297984, 21297983, 21297978, 21297936, 21297935, 21297932, 21297914, 21297913, 21297909, 21297899, 21297898, 21297893, 21297891, 21297884, 21297882, 21297880, 21297878, 21297876, 21297874, 21297868, 21297862, 21297857, 21297855, 21297852, 21297851, 21297842, 21297839, 21297837, 21297819, 21297818, 21297817, 21297813, 21297811, 21297809, 21297789, 21297788, 21297765, 21297756, 21297752, 21297751, 21297748, 21297733, 21297729, 21297728, 21297726, 21297716, 21297699, 21297688, 21297674, 21297670, 21297668, 21297664, 21297657, 21297656, 21297655, 21297639, 21297614, 21297588, 21297580, 21297564, 21297556, 21297554, 21297548, 21297535, 21297530, 21297523, 21297508, 21297506, 21297505, 21297499, 21297479, 21297474, 21297472, 21297462, 21297457, 21297448, 21297443, 21297425, 21297409, 21297388, 21297383, 21297380, 21297376, 21297370, 21297367, 21297363, 21297353, 21297352, 21297349, 21297344, 21297343, 21297322, 21297315, 21297306, 21297305, 21297303, 21297284, 21297279, 21297278, 21297268, 21297258, 21297257, 21297247, 21297241, 21297231, 21297230, 21297221, 21297213)
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve top stories function is working correctly", {
    result <- get_new_stories(2)
    expected <- list()
    item1 <- list(
        by = "sgallant",
        descendants = 53,
        id = 21301388,
        kids = c(21302857, 21305354),
        score = 179,
        time = as.POSIXct(1571528419, origin = "1970-01-01"),
        title = "Tina is not a CMS",
        type = "story",
        url = "https://tinacms.org/blog/announcing-tinacms/"
    )
    class(item1) <- "hn_item"

    item2 <- list(
      by = "Jefro118",
      descendants = 42,
      id = 21301382,
      kids = c(21302177, 21302032),
      score = 27,
      text = "Every winter",
      time =  as.POSIXct(1571528319, origin = "1970-01-01"),
      title = "Ask HN: How to deal with seasonal affective disorder?",
      type = "story"
    )
    class(item2) <- "hn_item"
    expected <- list(item1, item2)
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve best stories ids function is working correctly", {
    result <- get_best_stories_ids()
    expected <- c(21301388, 21301382, 21289827, 21280205, 21293505, 21289832, 21293891, 21281525, 21277580, 21297462, 21280918, 21286806, 21288185, 21294354, 21281025, 21298383, 21281042, 21280202, 21284770, 21299546, 21287924, 21280092, 21295942, 21280429, 21288663, 21278839, 21293132, 21292497, 21279366, 21293397, 21291282, 21294976, 21284962, 21282009, 21288029, 21297639, 21281724, 21293452, 21283791, 21292191, 21289237, 21298233, 21297789, 21287944, 21292476, 21295079, 21284387, 21292712, 21298227, 21287736, 21283994, 21288195, 21293550, 21292860, 21282647, 21298472, 21292205, 21283838, 21296167, 21298399, 21290881, 21278924, 21287498, 21295149, 21290306, 21286319, 21283861, 21278048, 21297499, 21296323, 21292495, 21288421, 21287955, 21290813, 21282680, 21293497, 21282812, 21291579, 21283835, 21279945, 21293544, 21289456, 21278705, 21298341, 21294569, 21287267, 21277690, 21285145, 21292727, 21282699, 21278009, 21297165, 21296855, 21289531, 21286104, 21299102, 21291131, 21285329, 21279725, 21293189, 21290508, 21280256, 21299032, 21291518, 21297868, 21292630, 21290839, 21286640, 21299768, 21296261, 21290200, 21288415, 21299086, 21293859, 21293272, 21286849, 21282982, 21299960, 21298920, 21292291, 21288280, 21299610, 21294554, 21300188, 21298830, 21293734, 21286574, 21289104, 21286074, 21278790, 21299127, 21297893, 21296799, 21280337, 21280238, 21298470, 21298304, 21295097, 21288988, 21283216, 21286192, 21284159, 21281541, 21278360, 21298637, 21293941, 21286229, 21278715, 21278630, 21293852, 21281533, 21286898, 21283988, 21281501, 21291210, 21280041, 21295516, 21289920, 21282282, 21299762, 21285728, 21285376, 21298217, 21297876, 21292536, 21290388, 21287650, 21286973, 21283528, 21278786, 21300052, 21298539, 21285127, 21278755, 21278152, 21292472, 21286537, 21284743, 21284208, 21279018, 21300191, 21283398, 21279752, 21286982, 21279756, 21300529, 21297880, 21292713, 21290643, 21288048, 21284050, 21283651, 21278948, 21298729, 21296417, 21291342, 21289899, 21280087, 21298620, 21298306)
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve best stories function is working correctly", {
    result <- get_best_stories(2)
    item1 <- list(
      by = "sgallant",
      descendants = 53,
      id = 21301388,
      kids = c(21302857, 21305354),
      score = 179,
      time = as.POSIXct(1571528419, origin = "1970-01-01"),
      title = "Tina is not a CMS",
      type = "story",
      url = "https://tinacms.org/blog/announcing-tinacms/"
    )
    class(item1) <- "hn_item"

    item2 <- list(
      by = "Jefro118",
      descendants = 42,
      id = 21301382,
      kids = c(21302177, 21302032),
      score = 27,
      text = "Every winter",
      time =  as.POSIXct(1571528319, origin = "1970-01-01"),
      title = "Ask HN: How to deal with seasonal affective disorder?",
      type = "story"
    )
    class(item2) <- "hn_item"
    expected <- list(item1, item2)
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve latest ask stories function is working correctly", {
    result <- get_latest_ask_stories_ids()
    expected <- c(21299546, 21278790, 21301212, 21299008, 21300422, 21298075, 21296612, 21289201, 21285728, 21285127, 21300013, 21287412, 21290096, 21279022, 21292229, 21294613, 21291937, 21281024, 21286460, 21280841, 21294197, 21278104, 21279655, 21279206, 21278171, 21279994, 21299534, 21298662, 21298172, 21297688, 21296306, 21296076, 21295819, 21295316, 21295300)
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve latest ask stories function is working correctly", {
    result <- get_latest_ask_stories(1)[[1]]
    expected <- list(
      by = "susam",
      descendants = 142,
      id = 21299546,
      kids = c(21300147, 21302020),
      score = 661,
      time = as.POSIXct(1571505668, origin = "1970-01-01"),
      title = "Structure and Interpretation of Computer Programs (1996) [pdf]",
      type = "story",
      url = "https://opendocs.github.io/sicp/sicp.pdf"
    )
    class(expected) <- "hn_item"
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve latest show stories ids function is working correctly", {
    result <- get_latest_show_stories_ids()
    expected <- c(21299546, 21278790, 21285419, 21295097, 21297664, 21293827, 21295516, 21298641, 21290785, 21298060, 21289251, 21278630, 21282699, 21290589, 21289074, 21280238, 21296684, 21294499, 21298811, 21295951, 21295361, 21289786, 21278269, 21285609, 21297535, 21290441, 21289704, 21289318, 21288239, 21287558, 21277804, 21281161, 21280281, 21280248, 21278875, 21278347, 21277744, 21290290, 21299536, 21299231, 21299147, 21299095, 21298530, 21298404, 21298373, 21296747, 21295306)
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve latest show stories function is working correctly", {
    result <- get_latest_show_stories(2)[[2]]
    expected <- list(
      by = "codesections",
      descendants = 122,
      id = 21278790,
      kids = c(21301138, 21300939),
      score = 199,
      time = as.POSIXct(1571284726, origin = "1970-01-01"),
      title = "Loopless Programming",
      type = "story",
      url = "https://code.jsoftware.com/wiki/Vocabulary/Loopless"
    )
    class(expected) <- "hn_item"
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve latest job stories ids function is working correctly", {
    result <- get_latest_job_stories_ids()
    expected <- c(21299546, 21278790, 21294929, 21293185, 21291184, 21289794, 21288829, 21287912, 21286762, 21285094, 21283006, 21280947, 21278814, 21278186)
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve latest job stories function is working correctly", {
    result <- get_latest_job_stories(1)[[1]]
    expected <- list(
      by = "susam",
      descendants = 142,
      id = 21299546,
      kids = c(21300147, 21302020),
      score = 661,
      time = as.POSIXct(1571505668, origin = "1970-01-01"),
      title = "Structure and Interpretation of Computer Programs (1996) [pdf]",
      type = "story",
      url = "https://opendocs.github.io/sicp/sicp.pdf"
    )
    class(expected) <- "hn_item"
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Retrieve updates function is working correctly", {
    result <- get_updates()
    expected <- list(
      items = c(21301373, 21301161, 21301232, 21301150, 21285242, 21278790, 21300188, 21269679, 21299086, 21298383, 21284743, 21293891),
      profiles = c("codesections", "klysm", "NOGDP")
    )
    expect_equal(result, expected)
  })
})

httptest::with_mock_api({
  test_that("Conversion of a comment to datarfame is working correctly", {
    comment <- get_item_by_id(21500829)
    result <- comment_to_dataframe_row(comment)
    expected <- data.frame(
      id = 21500829,
      deleted = FALSE,
      by = "vanniv",
        time = as.POSIXct(1573427819, origin = "1970-01-01"),
      text = "I find it fascinating which instances of governments violently oppressing their own people get the press excited enough to report, and which the press just buries.",
      dead = FALSE,
      parent = 21500569,
      stringsAsFactors = FALSE
    )
    expect_true(all.equal(result, expected))
    })
})

httptest::with_mock_api({
  test_that("Conversion of a deleted comment to datarfame is working correctly", {
    comment <- get_item_by_id(21501055)
    result <- comment_to_dataframe_row(comment)
    expected <- data.frame(
      id = 21501055,
      deleted = TRUE,
      by = c(NA),
      time = as.POSIXct(1573430397, origin = "1970-01-01"),
      text = c(NA),
      dead = FALSE,
      parent = 21500985,
      stringsAsFactors = FALSE
    )
    expect_true(all.equal(result, expected))
  })
})

httptest::with_mock_api({
  test_that("Retrieve comments function is working correctly", {
    story <- get_item_by_id(21500569)
    result <- get_comments(story)
    expected <- tibble::as.tibble(
      do.call(
        rbind,
        list(
          comment_to_dataframe_row(get_item_by_id(21500829)),
          comment_to_dataframe_row(get_item_by_id(21500985)),
          comment_to_dataframe_row(get_item_by_id(21501055))
          )
        )
      )
    expect_true(all.equal(result, expected))
  })
})

httptest::with_mock_api({
  test_that("Empty responses are handled correctly when retrieving items", {
    expect_warning(
      object = items <- get_items_by_ids(c(8863, 9000, 21278790)),
      regexp = "The content of the response is empty!.*9000.json"
    )

    expect_length(items, 3)
    expect_equal(items[[2]], NA)
  })
})


httptest::with_mock_api({
  test_that("Empty responses are handled correctly when retrieving comments", {
    expect_warning(
      object = result <- get_comments(get_item_by_id(1000)),
      regexp = "The content of the response is empty!.*3000.json"
    )

    expected <- tibble::as.tibble(
      do.call(
        rbind,
        list(
          comment_to_dataframe_row(get_item_by_id(2000))
        )
      )
    )
    expect_true(all.equal(result, expected))
  })
})
