% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qr-methods.R
\name{predict.hdqr}
\alias{predict.hdqr}
\title{Make Predictions from a `hdqr` Object}
\usage{
\method{predict}{hdqr}(object, newx, s = NULL, ...)
}
\arguments{
\item{object}{Fitted `hdqr()` object from which predictions are to be derived.}

\item{newx}{Matrix of new predictor values for which predictions are desired.
This must be a matrix and is a required argument.}

\item{s}{Values of the penalty parameter `lambda` for which predictions are requested.
Defaults to the entire sequence used during the model fit.}

\item{...}{Not used.}
}
\value{
Returns a vector or matrix of predicted values corresponding to the specified `lambda` values.
}
\description{
Produces fitted values for new predictor data using a fitted `hdqr()` object.
}
\details{
This function generates predictions at specified `lambda` values from a fitted `hdqr()` object.
It is essential to provide a new matrix of predictor values (`newx`) at which these predictions are to be made.
}
\examples{
set.seed(315)
n <- 100
p <- 400
x <- matrix(data = rnorm(n * p, mean = 0, sd = 1), nrow = n, ncol = p)
beta_star <- c(c(2, 1.5, 0.8, 1, 1.75, 0.75, 0.3), rep(0, (p - 7)))
eps <- rnorm(n, mean = 0, sd = 1)
y <- x \%*\% beta_star + eps
tau <- 0.5
lam2 <- 0.01
fit <- hdqr(x = x, y = y, tau = tau, lam2 = lam2)
preds <- predict(fit, newx = tail(x), s = fit$lambda[3:5])
}
\seealso{
\code{\link{hdqr}}, \code{\link{coef.hdqr}}
}
