% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_profile.R
\name{div_profile}
\alias{div_profile}
\title{Diversity profile}
\usage{
div_profile(count, qvalues, tree, hierarchy, level)
}
\arguments{
\item{count}{A vector or a matrix indicating the (relative) OTU/ASV counts of one or multiple samples. If a matrix is provided, columns must refer to samples and rows to OTUs.}

\item{qvalues}{A vector of sequential orders of diversity (default from 0 to 5). order=seq(from = 0, to = 5, by = (0.1))}

\item{tree}{A tree of class 'phylo'. The tip labels must match the names of the vector values (if one sample) or matrix rows (if multiple samples).}

\item{hierarchy}{A two-column matrix indicating the relation between samples (first column) and groups (second column).}

\item{level}{Whether to compute alpha or gamma diversities of the system or the groups specified in the hierarchy table.}
}
\value{
A vector or matrix containing diversity values at different orders of diversity (as specified in qvalues).
}
\description{
Create diversity profile vectors (single sample or system) or tables (multiple samples or groups) from count tables.
}
\details{
Diversity profile
}
\examples{
data(bat.diet.otutable)
data(bat.diet.tree)
data(bat.diet.hierarchy)
#One sample example
bat.diet.sample <- bat.diet.otutable[,1]
div_profile(count=bat.diet.sample,qvalues=seq(from = 0, to = 5, by = (0.1)))
#One sample example (phylogenetic Hill numbers)
names(bat.diet.sample) <- rownames(bat.diet.otutable)
div_profile(count=bat.diet.sample,qvalues=seq(from = 0, to = 5, by = (0.1)),tree=bat.diet.tree)
#Multiple samples
div_profile(bat.diet.otutable)
#Multiple groups (gamma diversity)
div_profile(bat.diet.otutable,hierarchy=bat.diet.hierarchy,level="gamma")
#Multiple groups (alpha diversity)
div_profile(bat.diet.otutable,hierarchy=bat.diet.hierarchy,level="alpha")
}
\references{
Alberdi, A., Gilbert, M.T.P. (2019). A guide to the application of Hill numbers to DNA-based diversity analyses. Molecular Ecology Resources, 19, 804-817.\cr\cr
Chao, A., Chiu, C.H., & Jost, L. (2014). Unifying species diversity, phylogenetic diversity, functional diversity, and related similarity and differentiation measures through hill numbers. Annual Review of Ecology Evolution and Systematics, 45, 297-324.
}
\seealso{
\code{\link{div_profile_plot}}, \code{\link{hill_div}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{alpha}
\keyword{beta}
\keyword{gamma}
\keyword{hill}
