% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hornpa.R
\name{hornpa}
\alias{hornpa}
\title{Perform Horn's Parallel Analysis using Simulated Data}
\usage{
hornpa(k, size = 100, reps = 100, seed = NA, p = 0.95, method = c("pca", "pa"))
}
\arguments{
\item{k}{The number of variables in your dataset.}

\item{size}{The number of observations in your dataset.}

\item{reps}{How many simulated datasets to create.}

\item{seed}{Use an optional seed to reproduce the same results each time.}

\item{p}{Specify the percentile which to evaluate the eigenvalues. Defaults to the 95th percentile.}

\item{method}{Specify what type of analysis is run (using a principal component analysis or principal axis factoring). Defaults to pca if not specified.}
}
\value{
Mean and the specified percentile eigenvalues based on a user defined set of random datasets. Compare the eigenvalues from your dataset to the eigenvalues generated with the synthetic datasets. Results are comparable to the SPSS and SAS syntax written by O'Connor (2000).
}
\description{
A stand alone function to run a parallel analysis. The program generates a specified number of datasets based on the number of variables entered by the user. Eigenvalues are computed for the each dataset and collected.
The mean and the specified percentile (95th is the default) are computed. The output table shows how large eigenvalues can be as a result of 
merely using randomly generated datasets. If the user's own dataset has an actual eigenvalue greater than the generated eigenvalue,
that lends support to retain that factor. In other words, if the i(th) eigenvalue from the actual data was larger than the percentile of the (i)th eigenvalue generated using
randomly generated data, empirical support is provided to retain that factor. Horn's (1965) article suggested using the mean vs. the 95th percentile commonly used today (O'Conner, 2000).

If principal axis factoring is specified, squared multiple correlations are substituted in the diagonal
of the correlation matrix.
}
\details{
User specifies the number of variables in the synthetic dataset, the number of observations, the number of correlation matrices to generate, and the percentile.
}
\examples{
hornpa(k = 10, size = 100, reps = 200)
hornpa(k = 15, size = 100, reps = 200, method = "pa", seed = 123)
hornpa(k = 12, size = 200, reps = 100, p = .99)
}
\references{
Horn, J. (1965). A rationale and test for the number of factors in factor analysis. Psychometrika, 32, 179-185.

O'Connor, B. (2000). SPSS and SAS programs for determining the number of components using parallel analysis and Velicer's MAP test, Behavior Research Methods, Instruments and Computers, 32, 396-402.
}
