% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maf.R
\name{.maf}
\alias{.maf}
\title{Calculate Minor Allele Frequency (MAF)}
\usage{
.maf(snp)
}
\arguments{
\item{snp}{A numeric vector representing the genotype of individuals for a single SNP. 
The genotype should be coded as 0 for AA, 1 for AB, and 2 for BB. Use 9 to represent missing data.}
}
\value{
A numeric value representing the minor allele frequency (MAF) for the SNP data provided.
}
\description{
This function calculates the minor allele frequency (MAF) for a given single nucleotide polymorphism (SNP) data. 
The SNP data should be coded numerically: 0 for homozygous for the first allele (AA), 
1 for heterozygous (AB), and 2 for homozygous for the second allele (BB). Missing data should be coded as 9.
}
\examples{
snp_data <- c(0, 0, 1, 2, 2, 9)
maf_value <- .maf(snp_data)
print(maf_value)

}
