% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_clearance_frac.R
\name{calc_clearance_frac}
\alias{calc_clearance_frac}
\title{Calculate the fractional contributions to total clearance}
\usage{
calc_clearance_frac(
  fraction.params = c("Clint", "Qgfrc"),
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  species = "human",
  default.to.human = FALSE,
  suppress.messages = FALSE,
  model = "3compartmentss",
  restrictive.clearance = TRUE,
  parameterize.args = list(),
  analytic_css.args = list()
)
}
\arguments{
\item{fraction.params}{A vector of character strings identifying the
parameters whose fractional contributions are to be calculated. Defaults to
'Qfgr' and 'Qtotal.liverc'.}

\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
 -- if parameters is not specified then the chemical must be identified by 
either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from the appropriate parameterization function
for the model indicated by argument model}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{(Logical) Substitutes missing rat values with
human values if TRUE. (Not applicable for `calc_fabs.oral`.)
(Defaults to `FALSE`.)}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{model}{Model used in calculation, for example'pbtk' for the multiple compartment
model,'3compartment' for the three compartment model, and '1compartment' for
the one compartment model. Defaults to '3compartmentss'.}

\item{restrictive.clearance}{Protein binding not taken into account (set to 1)
in liver clearance if FALSE.}

\item{parameterize.args}{Named list of any additional arguments passed to
model parameterization function (other than the already-named arguments).
Default `list()` to pass no additional arguments.}

\item{analytic_css.args}{Arguments to analytical Css function}
}
\value{
A numeric fraction unpbound in plasma between zero and one
}
\description{
Steady-state clearance is a function of multiple processes. For example,
meabolism in the liver and glomerular filtration in the kidney. This function
takes a list of parameters potentially impacting total clearance and
iteratively sets all but one of the paramters to zero. This allows
calculation of the fration of total clearance driven by that parameter.
}
\examples{

# 3compartmentss model:
calc_clearance_frac(chem.name="bisphenola")

\donttest{
# pbtk model:
calc_clearance_frac(chem.name="bisphenola",
                    model="pbtk",
                    fraction.params=c("Qgfrc","Clmetabolismc"))

# A model with exhalation:
# sumclearances model:
calc_clearance_frac(chem.name="bisphenola",
                    model="sumclearances",
                    fraction.params=c("Clint","Qgfrc","Qalvc"))

calc_clearance_frac(chem.name="toluene",
                    model="sumclearances",
                    fraction.params=c("Clint","Qgfrc","Qalvc"))
                      
# 3comp2 model:
calc_clearance_frac(chem.name="toluene",
                    model="3compartment2",
                    fraction.params=c("Clmetabolismc","Qgfrc","Qalvc"))
}

}
\author{
John Wambaugh
}
