% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethCl_CS_Arbitrary.R
\name{froude_number}
\alias{froude_number}
\alias{froude_number,CSarbitrary-method}
\alias{froude_number,CScircle-method}
\title{Froude Number}
\usage{
froude_number(object, v, h)
}
\arguments{
\item{object}{A CSarbitrary or CScircle object.}

\item{v}{Flow velocity  [m/s].}

\item{h}{Flow depth [m].}
}
\value{
Froude number [-]
}
\description{
Calculates the froude number of a CSarbitrary or CScircle object for a
 given water level and velocity under uniform flow conditions.
}
\examples{

# Example for CSarbitrary object
x <- c(0, 4, 9, 13)
z <- c(2, 0, 0, 2)
cs <- CSarbitrary(x = x, z = z, xb_l = 4, xb_r = 9, kSt_B = 35,
                  kSt_l = 45, kSt_r = 45)
froude_number(cs,h=1, v = 2.5)

# Example for CScircle object
csC <- CScircle(Di = 0.7,ks = 1.5, kSt = 75)
froude_number(csC, h = 0.46, v = 2.5)

}
