% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.spc.Kaiser.R
\name{read.spc.Kaiser}
\alias{read.spc.Kaiser}
\alias{read.spc.KaiserMap}
\alias{read.spc.KaiserLowHigh}
\title{read Kaiser .spc files}
\usage{
read.spc.Kaiser(files, ..., glob = TRUE)

read.spc.KaiserMap(files, keys.log2data = NULL, ...)

read.spc.KaiserLowHigh(
  files = stop("file names needed"),
  type = c("single", "map"),
  ...,
  glob = TRUE
)
}
\arguments{
\item{files}{If \code{glob = TRUE}, \code{filename} can contain wildcards.
Thus all files matching the name pattern in \code{filename} can be
specified.}

\item{glob}{If \code{TRUE} the filename is interpreted as a wildcard
containing file name pattern and expanded to all matching file names.}

\item{keys.log2data, ...}{All further arguments are handed over directly to \code{\link{read.spc}}.}

\item{type}{what kind of measurement was done? If \code{"map"}, \code{read.spc.KaiserMap} is used
instead of \code{read.spc.Kaiser}.}
}
\value{
hyperSpec
}
\description{
Import functions for Kaiser Optical Systems .spc files
}
\details{
\code{read.spc.Kaiser} imports sets of .spc files written by Kaiser Optical Systems' Hologram
software.  It may also serve as an example how to write wrapper functions for \code{read.spc} to
conveniently import specialized sets of .spc files.
}
\examples{
## for examples, please see `vignette ("fileio", package = "hyperSpec")`.
}
