% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_unidata.R
\name{unidata}
\alias{unidata}
\title{Unidata Class}
\usage{
unidata(times = integer(0), series = integer(0), series_esd = integer(0))
}
\arguments{
\item{times}{A numeric vector representing the time points.}

\item{series}{A numeric vector representing the values of the time series.}

\item{series_esd}{A numeric vector representing the error standard deviations of the time series.}
}
\description{
The `unidata` class is an S7 class designed to represent univariate irregularly observed time series models
with associated times, values, and optional error standard deviations.
}
\section{Validation Rules}{

- `@times`, `@series`, and `@series_esd` must be vectors (not matrices or arrays).
- The lengths of `@times` and `@series` must be the same.
- If `@series_esd` is provided, it must be a vector with the same length as `@series`.
}

\examples{
# Create a unidata object
unidata_instance <- unidata(
  times = c(1, 2, 3, 4),
  series = c(10, 20, 15, 25),
  series_esd = c(1, 1.5, 1.2, 1.8)
)

}
