% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iARtest.R
\name{iARTest}
\alias{iARTest}
\title{Test for the significance of the autocorrelation estimated by the iAR package models in periodic irregularly observed time series}
\usage{
iARTest(
  series,
  times,
  series_esd = 0,
  f,
  coef,
  model = "iAR",
  plot = TRUE,
  xlim = c(-1, 0),
  df = 3
)
}
\arguments{
\item{series}{Array with the time series observations.}

\item{times}{Array with the irregular observational times.}

\item{series_esd}{Array with the variance of the measurement errors.}

\item{f}{Frequency (1/Period) of the raw time series.}

\item{coef}{autocorrelation estimated by one of the iAR package models.}

\item{model}{model used to estimate the autocorrelation parameter ("iAR", "iAR-Gamma", "iAR-T", "CiAR" or "BiAR").}

\item{plot}{logical; if true, the function return a density plot of the distribution of the bad fitted examples; if false, this function does not return a plot.}

\item{xlim}{The x-axis limits (x1, x2) of the plot. Only works if plot='TRUE'. See \code{\link{plot.default}} for more details.}

\item{df}{degrees of freedom parameter of the iAR-T model.}
}
\value{
A list with the following components:
\item{phi}{ MLE of the autocorrelation parameter of the iAR/CiAR model.}
\item{bad}{ A matrix with two columns. The first column contains the incorrect frequencies used to fit each harmonic model. The second column has the MLEs of the autocorrelation parameters of the iAR/CiAR model that has been fitted to the residuals of the harmonic model fitted using the frequencies of the first column.}
\item{norm}{ Mean and variance of the normal distribution of the bad fitted examples.}
\item{z0}{ Statistic of the test (log(abs(phi))).}
\item{pvalue}{ P-value computed for the test.}
}
\description{
This function perform a test for the significance of the autocorrelation estimated by the iAR package models. This test is based on the residuals of the periodical time series fitted with an harmonic model using an incorrect period.
}
\details{
The null hypothesis of the test is: The autocorrelation estimated in the time series belongs to the distribution of the coefficients estimated for the residuals of the data fitted using wrong periods. Therefore, if the hypothesis is rejected, it can be concluded that the residuals of the harmonic model do not remain a time dependency structure.The statistic of the test is log(phi) which was contrasted with a normal distribution with parameters corresponding to the log of the mean and the variance of the phi computed for the residuals of the bad fitted light curves.
}
\examples{
data(clcep)
f1=0.060033386
#results=harmonicfit(file=clcep,f1=f1)
#y=results$res/sqrt(var(results$res))
#st=results$t
#res3=iARloglik(y,st,standardized=TRUE)[1]
#res3$coef
#require(ggplot2)
#test<-iARTest(series=clcep[,2],times=clcep[,1],f=f1,coef=res3$coef,
#model="iAR",plot=TRUE,xlim=c(-10,0.5))
#test
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{clcep}}, \code{\link{harmonicfit}},\code{\link{iARPermutation}}
}
