% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{rename_levels}
\alias{rename_levels}
\title{Rename the levels of a categorical variable}
\usage{
rename_levels(data, var, tobe_asis, name = NULL)
}
\arguments{
\item{data}{a dataframe with the column to be renamed}

\item{var}{a character of the categorical variable to rename}

\item{tobe_asis}{a named list of the old level names assigned
to the new level names
ie. list('new level names' = 'old level names')}

\item{name}{a name for the new variable}
}
\value{
original dataframe containing a new column of the renamed categorical
        variable with tidyverse code attached
}
\description{
Rename the levels of a categorical variables, and returns the result
along with tidyverse code used to generate it.
}
\examples{
renamed <- rename_levels(iris,
    var = "Species",
    tobe_asis = list(set = "setosa", ver = "versicolor")
)
cat(code(renamed))
head(renamed)

}
\seealso{
\code{\link{code}}
}
\author{
Zhaoming Su
}
