% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probtrans_weib.R
\name{probtrans_weib}
\alias{probtrans_weib}
\title{Determine transition probabilities for a multi-state model with Weibull
hazards for the transitions.}
\usage{
probtrans_weib(transMat, times, shapes, scales, type = c("prodint", "ODE"))
}
\arguments{
\item{transMat}{A transition matrix as generated by \code{mstate::transMat}
describing the possible transitions for the multi-state model.}

\item{times}{The times at which the transition probabilities should be 
determined. Will always determine the probabilities forward in time starting 
from \code{min(times)}.}

\item{shapes}{The Weibull shapes corresponding to the numbered transitions 
in \code{transMat}. See \code{?pweibull} for more info.}

\item{scales}{The Weibull scales corresponding to the numbered transitions 
in \code{transMat}. See \code{?pweibull} for more info.}

\item{type}{Should the transition probabilities be determined using 
product integration \code{"prodint"} or by solving the Kolmogorov forward ordinary differential 
equation \code{"ODE"}.}
}
\value{
An object containing the "true" transition probabilities for the 
specified Weibull hazards.
}
\description{
Determine transition probabilities for a multi-state model with Weibull
hazards for the transitions.
}
\examples{
#Illness-death model
tmat <- mstate::trans.illdeath()
IDM <- probtrans_weib(tmat, seq(0, 15, 0.01), shapes = c(0.5, 0.5, 2), 
                      scales = c(5, 10, 10/gamma(1.5)), type = "prodint")
IDM2 <- probtrans_weib(tmat, seq(0, 15, 0.01), shapes = c(0.5, 0.5, 2), 
                       scales = c(5, 10, 10/gamma(1.5)), type = "ODE")
plot(IDM)
plot(IDM2)

#Extended illness-death model
tmat <- mstate::transMat(list(c(2, 3), c(4), c(), c()))
IDM <- probtrans_weib(tmat, seq(0, 15, 0.01), shapes = c(0.5, 0.5, 2), 
                      scales = c(5, 10, 10/gamma(1.5)), type = "prodint")
IDM2 <- probtrans_weib(tmat, seq(0, 15, 0.01), shapes = c(0.5, 0.5, 2), 
                       scales = c(5, 10, 10/gamma(1.5)), type = "ODE")
plot(IDM)
plot(IDM2)


}
