% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incRatt.R
\name{incRatt}
\alias{incRatt}
\title{Calculation of the percentage of daily time spent in nest}
\usage{
incRatt(data, vector.incubation)
}
\arguments{
\item{data}{data frame containing a time-series vector of 1's and 0's, where "1"
means "incubating individual inside nest" and "0" means "incubating individual
outside nest". This vector, 
under the name of "inc.vector" is provided by \code{\link{incRscan}} in the 
first object of the returned list. A column named "date" is needed to refer to daily
calculations.}

\item{vector.incubation}{name of the column (vector class) storing the
information about the presence/absence of the incubating individual in the nest.}
}
\value{
Daily percentage of time in nest, returned in a 
data frame with one day per raw.
}
\description{
This function calculates percentage of day time spent inside nest
based on the "inc.vector" variable produced by \code{\link{incRscan}} (or any other method).
Current version do not discriminate day and night times.
}
\details{
The 'date' column must have a 'year-month-day' format for this function to run correctly.
}
\examples{
#' # loading example data
data(incR_procdata)
incRatt (data=incR_procdata, 
               vector.incubation="incR_score")
}
\seealso{
\code{\link{incRprep}} \code{\link{incRscan}} \code{\link{incRact}}
}
