% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params_check_types.R
\name{check_single}
\alias{check_single}
\title{Checks a set of variables are all of length one}
\usage{
check_single(
  ...,
  .message = "`{param}` is not length one: ({err}).",
  .env = rlang::caller_env()
)
}
\arguments{
\item{...}{a list of symbols}

\item{.message}{a glue specification containing \code{{param}} as the name of the
parameter and \code{{err}} the cause of the error}

\item{.env}{the environment to check (defaults to calling environment)}
}
\value{
nothing. called for side effects. throws error if not all variables can be coerced.
}
\description{
Checks a set of variables are all of length one
}
\examples{
a = 1
b = "Hello"
g = NA
check_single(a,b,g)

c= c(1,2,3)
d=list(a,b)
try(check_single(c,d,missing))
}
\concept{parameter_checks}
