% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semaphore.r
\name{semaphore}
\alias{semaphore}
\alias{with.semaphore}
\title{Increment and Decrement an Integer}
\usage{
semaphore(name = uid(), assert = NULL, value = 0, cleanup = FALSE, file = NULL)

\method{with}{semaphore}(data, expr, alt_expr = NULL, timeout_ms = Inf, ...)
}
\arguments{
\item{name}{Unique ID. Alphanumeric, starting with a letter.}

\item{assert}{Apply an additional constraint.
\itemize{
\item \code{'create'} - Error if the semaphore \strong{already exists}.
\item \code{'exists'} - Error if the semaphore \strong{doesn't exist}.
\item \code{NULL} - No constraint; create the semaphore if it doesn't exist.
}}

\item{value}{The initial value of the semaphore.}

\item{cleanup}{Remove the semaphore when the R session exits. If \code{FALSE},
the semaphore will persist until \verb{$remove()} is called or the
operating system is restarted.}

\item{file}{Use a hash of this file/directory path as the semaphore name.
The file itself will not be read or modified, and does not need to
exist.}

\item{data}{A \code{semaphore} object.}

\item{expr}{Expression to evaluate if a semaphore is posted.}

\item{alt_expr}{Expression to evaluate if \code{timeout_ms} is reached.}

\item{timeout_ms}{Maximum time (in milliseconds) to block the process
while waiting for the operation to succeed. Use \code{0} or \code{Inf} to
return immediately or only when successful, respectively.}

\item{...}{Not used.}
}
\value{
\code{semaphore()} returns a \code{semaphore} object with the following methods:
\itemize{
\item \verb{$name}
\itemize{
\item Returns the semaphore's name (scalar character).
}
\item \verb{$post()}
\itemize{
\item Returns \code{TRUE} if the increment was successful, or \code{FALSE} on error.
}
\item \verb{$wait(timeout_ms = Inf)}
\itemize{
\item Returns \code{TRUE} if the decrement was successful, or \code{FALSE} if the timeout is reached.
}
\item \verb{$remove()}
\itemize{
\item Returns \code{TRUE} if the semaphore was successfully deleted from the operating system, or \code{FALSE} on error.\cr\cr
}
}

\code{with()} returns \code{eval(expr)} on success, or \code{eval(alt_expr)} if the timeout is reached.
}
\description{
A semaphore is an integer that the operating system keeps track of. Any
process that knows the semaphore's identifier can increment or decrement its
value, though it cannot be decremented below zero.\cr\cr
When the semaphore is zero, calling \verb{$wait(timeout_ms = 0)} will
return \code{FALSE} whereas \verb{$wait(timeout_ms = Inf)} will block until the
semaphore is incremented by another process. If multiple processes are
blocked, a single call to \verb{$post()} will only unblock one of the
blocked processes.\cr\cr
It is possible to wait for a specific amount of time, for example,
\verb{$wait(timeout_ms = 10000)} will wait for 10 seconds. If the
semaphore is incremented within those 10 seconds, the function will
immediately return \code{TRUE}. Otherwise it will return \code{FALSE} at the 10 second
mark.
}
\examples{

sem <- interprocess::semaphore()
print(sem)

sem$post()
sem$wait(timeout_ms = 0)
sem$wait(timeout_ms = 0)

sem$post()
with(sem, 'success', 'timed out', timeout_ms = 0)
with(sem, 'success', 'timed out', timeout_ms = 0)

sem$remove()
}
\seealso{
Other shared objects: 
\code{\link{msg_queue}()},
\code{\link{mutex}()}
}
\concept{shared objects}
