% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_AIC.R
\name{AIC.pk}
\alias{AIC.pk}
\title{Akaike information criterion}
\usage{
\method{AIC}{pk}(
  object,
  newdata = NULL,
  model = NULL,
  method = NULL,
  exclude = TRUE,
  drop_obs = TRUE,
  ...,
  k = 2
)
}
\arguments{
\item{object}{A `pk` object}

\item{newdata}{Optional: A `data.frame` with new data for which to compute
log-likelihood. If NULL (the default), then log-likelihoods will be
computed for the data in `object$data`. `newdata` is required to contain at
least the following variables: `Time`, `Time.Units`, `Dose`,
`Route`,`Media`, `Conc`, `Detect`, `N_Subjects`. Before log-likelihood is
calculated, `Time` will be transformed according to the transformation in
`object$scales$time` and `Conc` will be transformed according to the
transformation in `object$scales$conc`.}

\item{model}{Optional: Specify one or more of the fitted models for which to
calculate log-likelihood. If NULL (the default), log-likelihoods will be
returned for all of the models in `object$stat_model`.}

\item{method}{Optional: Specify one or more of the [optimx::optimx()] methods
for which to make predictions and calculate AICs. If NULL (the default),
log-likelihoods will be returned for all of the models in
`object$settings_optimx$method`.}

\item{exclude}{Logical: `TRUE` to compute the AIC after removing any
observations in the data marked for exclusion (if there is a variable
`exclude` in the data, an observation is marked for exclusion when `exclude
%in% TRUE`). `FALSE` to include all observations, regardless of exclusion
status. Default `TRUE`.}

\item{drop_obs}{Logical: `TRUE` to drop the observations column in the output
of [logLik()].}

\item{...}{Additional argument. Not in use.}

\item{k}{Default 2. The `k` parameter in the log-likelihood formula (see
Details). Must be named if used.}
}
\value{
A data.frame with log-likelihood values and calculated AIC using `newdata`.
  There is one row for each model in `obj`'s [stat_model()] element and
  each [optimx::optimx()] method (specified in [settings_optimx()]).
}
\description{
Get the Akaike information criterion (AIC) for a fitted `pk` object
}
\details{
The AIC is calculated from the log-likelihood (LL) as follows:
\deqn{\textrm{AIC} = -2\textrm{LL} + k n_{par}}

where \eqn{n_{par}} is the number of parameters in the fitted model, and
\eqn{k = 2} for the standard AIC.
}
\seealso{
Other fit evaluation metrics: 
\code{\link{AAFE.pk}()},
\code{\link{AFE.pk}()},
\code{\link{BIC.pk}()},
\code{\link{logLik.pk}()},
\code{\link{rmse.pk}()},
\code{\link{rsq.pk}()}

Other log likelihood functions: 
\code{\link{BIC.pk}()},
\code{\link{logLik.pk}()}

Other methods for fitted pk objects: 
\code{\link{AAFE.pk}()},
\code{\link{AFE.pk}()},
\code{\link{BIC.pk}()},
\code{\link{coef.pk}()},
\code{\link{coef_sd.pk}()},
\code{\link{eval_tkstats.pk}()},
\code{\link{get_fit.pk}()},
\code{\link{get_hessian.pk}()},
\code{\link{get_tkstats.pk}()},
\code{\link{logLik.pk}()},
\code{\link{predict.pk}()},
\code{\link{residuals.pk}()},
\code{\link{rmse.pk}()},
\code{\link{rsq.pk}()}
}
\author{
Caroline Ring, Gilberto Padilla Mercado
}
\concept{fit evaluation metrics}
\concept{log likelihood functions}
\concept{methods for fitted pk objects}
